/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.service.impl.operate.mail;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.ruoyi.common.core.exception.ServiceException;
import com.ruoyi.common.core.utils.DateUtils;
import com.ruoyi.common.core.utils.StringUtils;
import com.ruoyi.common.security.utils.SecurityUtils;
import com.ruoyi.rearend.domain.GameMail;
import com.ruoyi.rearend.domain.GameMailDelete;
import com.ruoyi.rearend.domain.GameMailExamine;
import com.ruoyi.rearend.domain.GameMailReduceProp;
import com.ruoyi.rearend.domain.GameMailSendLog;
import com.ruoyi.rearend.domain.RearServerConfig;
import com.ruoyi.rearend.domain.po.InterfaceSendPO;
import com.ruoyi.rearend.domain.po.operate.mail.GameMailApiPO;
import com.ruoyi.rearend.domain.po.operate.mail.MailExaminePO;
import com.ruoyi.rearend.domain.po.player.BatchPlayerQueryPO;
import com.ruoyi.rearend.domain.vo.InterfaceSendVO;
import com.ruoyi.rearend.domain.vo.operate.mail.GameMailApiVO;
import com.ruoyi.rearend.domain.vo.operate.mail.GameMailExamineVO;
import com.ruoyi.rearend.enums.BaseSuccessFailEnums;
import com.ruoyi.rearend.enums.BaseYesNoEnums;
import com.ruoyi.rearend.enums.operate.MailExamineStateEnums;
import com.ruoyi.rearend.enums.operate.MailInternalMarkEnums;
import com.ruoyi.rearend.enums.operate.MailStateEnums;
import com.ruoyi.rearend.enums.operate.MailTypeEnums;
import com.ruoyi.rearend.enums.operate.MailWayEnums;
import com.ruoyi.rearend.enums.operate.mailSendTypeEnums;
import com.ruoyi.rearend.enums.palyer.SendingTypeEnums;
import com.ruoyi.rearend.mapper.operate.mail.GameMailExamineMapper;
import com.ruoyi.rearend.service.impl.operate.mail.GameMailDeleteServiceImpl;
import com.ruoyi.rearend.service.impl.operate.mail.GameMailReducePropServiceImpl;
import com.ruoyi.rearend.service.impl.operate.mail.GameMailSendLogServiceImpl;
import com.ruoyi.rearend.service.impl.operate.mail.GameMailServiceImpl;
import com.ruoyi.rearend.service.impl.server.RearServerServiceImpl;
import com.ruoyi.rearend.service.operate.mail.IGameMailExamineService;
import com.ruoyi.rearend.utils.InterfaceSendUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class GameMailExamineServiceImpl
implements IGameMailExamineService {
    @Autowired
    private GameMailExamineMapper gameMailExamineMapper;
    @Autowired
    private RearServerServiceImpl rearServerServiceImpl;
    @Autowired
    private GameMailServiceImpl gameMailServiceImpl;
    @Autowired
    private GameMailSendLogServiceImpl gameMailSendLogServiceImpl;
    @Autowired
    private InterfaceSendUtils interfaceSendUtils;
    @Autowired
    private GameMailReducePropServiceImpl gameMailReducePropServiceImpl;
    @Autowired
    private GameMailDeleteServiceImpl gameMailDeleteServiceImpl;
    private static final Logger log = LoggerFactory.getLogger(GameMailExamineServiceImpl.class);
    private static ThreadPoolExecutor executorService = new ThreadPoolExecutor(10, 12, 1000L, TimeUnit.MILLISECONDS, new LinkedBlockingDeque<Runnable>(1000), Executors.defaultThreadFactory(), new ThreadPoolExecutor.AbortPolicy());

    public GameMailExamineVO selectGameMailExamineById(Long Id) {
        GameMailExamineVO gameMailExamineVO = this.gameMailExamineMapper.selectGameMailExamineById(Id);
        gameMailExamineVO.setMailInternalMarkDescribe(MailInternalMarkEnums.getDescByValue((Integer)gameMailExamineVO.getMailInternalMark()));
        if (StringUtils.isEmpty((String)gameMailExamineVO.getMailPropJson())) {
            return gameMailExamineVO;
        }
        JSONArray list = JSON.parseArray((String)gameMailExamineVO.getMailPropJson());
        ArrayList<Map> mailPropJsonList = new ArrayList<Map>();
        for (Object object : list) {
            Map ret = (Map)object;
            mailPropJsonList.add(ret);
        }
        gameMailExamineVO.setMailPropJsonList(mailPropJsonList);
        return gameMailExamineVO;
    }

    public List<GameMailExamine> selectGameMailExamineList(GameMailExamine gameMailExamine) {
        return this.gameMailExamineMapper.selectGameMailExamineList(gameMailExamine);
    }

    public int insertGameMailExamine(GameMailExamine gameMailExamine) {
        gameMailExamine.setCreateTime(DateUtils.getNowDate());
        return this.gameMailExamineMapper.insertGameMailExamine(gameMailExamine);
    }

    public int updateGameMailExamine(GameMailExamine gameMailExamine) {
        gameMailExamine.setUpdateTime(DateUtils.getNowDate());
        return this.gameMailExamineMapper.updateGameMailExamine(gameMailExamine);
    }

    public int deleteGameMailExamineByIds(Long[] Ids) {
        return this.gameMailExamineMapper.deleteGameMailExamineByIds(Ids);
    }

    public int deleteGameMailExamineById(Long Id) {
        return this.gameMailExamineMapper.deleteGameMailExamineById(Id);
    }

    @Transactional(rollbackFor={Exception.class})
    public int mailExamine(MailExaminePO mailExaminePO) {
        GameMailExamine gameMailExamine = this.mailExamineCheck(mailExaminePO);
        GameMailExamine gameMailExamineUpdate = new GameMailExamine();
        gameMailExamineUpdate.setId(mailExaminePO.getId());
        gameMailExamineUpdate.setUpdateBy(SecurityUtils.getUsername());
        gameMailExamineUpdate.setExamineState(mailExaminePO.getExamineStateMark());
        gameMailExamineUpdate.setExamineContent(mailExaminePO.getExamineContent());
        gameMailExamineUpdate.setExamineTime(new Date());
        gameMailExamineUpdate.setExamineName(SecurityUtils.getUsername());
        int state = this.updateGameMailExamine(gameMailExamineUpdate);
        Boolean sendingState = mailExaminePO.getExamineStateMark().equals(MailExamineStateEnums.ADOPT.getValue()) ? this.mailExamineAdopt(mailExaminePO, gameMailExamine) : this.mailExamineRefuse(mailExaminePO);
        gameMailExamine.setExamineContent(mailExaminePO.getExamineContent());
        if (sendingState.booleanValue() && MailWayEnums.SENDING.getValue() == gameMailExamine.getMailWay().intValue()) {
            this.mailApiSendingFuture(gameMailExamine);
        } else if (sendingState.booleanValue() && MailWayEnums.BUTTON_UP.getValue() == gameMailExamine.getMailWay().intValue()) {
            this.mailReducePropFuture(gameMailExamine);
        } else if (sendingState.booleanValue() && MailWayEnums.DELETE_MAIL.getValue() == gameMailExamine.getMailWay().intValue()) {
            this.mailDeleteFuture(gameMailExamine);
        }
        return state;
    }

    public GameMailExamine mailExamineCheck(MailExaminePO mailExaminePO) {
        GameMailExamineVO gameMailExamineVO = this.gameMailExamineMapper.selectGameMailExamineById(mailExaminePO.getId());
        Date newDate = new Date();
        Date mailTimingSendTime = gameMailExamineVO.getMailTimingSendTime();
        Date mailExpireTime = gameMailExamineVO.getMailExpireTime();
        if (!gameMailExamineVO.getExamineState().equals(MailExamineStateEnums.AUDIT.getValue())) {
            throw new ServiceException("\u6b64\u90ae\u4ef6\u5df2\u88ab\u5ba1\u6279\u8fc7\u6216\u8005\u5df2\u7ecf\u8fc7\u671f\u4e86");
        }
        if (mailTimingSendTime != null && mailTimingSendTime.compareTo(newDate) == -1) {
            throw new ServiceException("\u6b64\u90ae\u4ef6\u5df2\u8fc7\u9884\u53d1\u9001\u65f6\u95f4,\u5df2\u6807\u8bb0\u4e3a\u8fc7\u671f\u90ae\u4ef6,\u65e0\u9700\u5ba1\u6279");
        }
        if (mailExpireTime != null && mailExpireTime.compareTo(newDate) == -1) {
            throw new ServiceException("\u6b64\u90ae\u4ef6\u7684\u8fc7\u671f\u65f6\u95f4\u5df2\u5230,\u5df2\u6807\u8bb0\u4e3a\u8fc7\u671f\u90ae\u4ef6,\u65e0\u9700\u5ba1\u6279");
        }
        GameMailExamine gameMailExamine = new GameMailExamine();
        BeanUtils.copyProperties((Object)gameMailExamineVO, (Object)gameMailExamine);
        return gameMailExamine;
    }

    public Boolean mailExamineAdopt(MailExaminePO mailExaminePO, GameMailExamine gameMailExamine) {
        Boolean state = false;
        GameMail gameMail = new GameMail();
        gameMail.setId(mailExaminePO.getMailId());
        gameMail.setExamineTime(new Date());
        gameMail.setExamineContent(mailExaminePO.getExamineContent());
        if (gameMailExamine.getMailTimingSendTime() != null) {
            gameMail.setMailState(MailStateEnums.TO_BE_SENT.getValue());
            this.gameMailServiceImpl.examineUpdateMail(gameMail);
        } else {
            state = true;
        }
        return state;
    }

    public Boolean mailExamineRefuse(MailExaminePO mailExaminePO) {
        GameMail gameMail = new GameMail();
        gameMail.setId(mailExaminePO.getMailId());
        gameMail.setExamineTime(new Date());
        gameMail.setExamineContent(mailExaminePO.getExamineContent());
        gameMail.setMailState(MailStateEnums.NOT_PASSED.getValue());
        this.gameMailServiceImpl.examineUpdateMail(gameMail);
        return false;
    }

    public Future<Integer> mailApiSendingFuture(GameMailExamine gameMailExamine) {
        return executorService.submit(() -> {
            try {
                this.crossBarHandle(gameMailExamine);
                HashMap<String, String> jsonMap = new HashMap<String, String>();
                if (SendingTypeEnums.CUSTOM_AND_USER_PLAYER_ID.getValue() == gameMailExamine.getMailSendingType() || SendingTypeEnums.CUSTOM_AND_USER_ACCOUNT.getValue() == gameMailExamine.getMailSendingType()) {
                    List<String> serverList = Arrays.asList(gameMailExamine.getUserPlayerId().split("\n"));
                    String head = "";
                    int appointIndex = 0;
                    for (int i = 0; i < serverList.size(); ++i) {
                        appointIndex = serverList.get(i).indexOf(",[");
                        head = head + serverList.get(i).substring(0, appointIndex) + "\n";
                        List<String> dataList = Arrays.asList(serverList.get(i).split(","));
                        jsonMap.put(dataList.get(0), serverList.get(i).substring(serverList.get(i).lastIndexOf(",[") + 1));
                    }
                    gameMailExamine.setUserPlayerId(head);
                }
                List batchPlayerQueryPOList = this.interfaceSendUtils.manyServerPlayerHandle(gameMailExamine.getUserPlayerId());
                for (BatchPlayerQueryPO batchPlayerQueryPO : batchPlayerQueryPOList) {
                    gameMailExamine.setServerId(batchPlayerQueryPO.getServerId());
                    gameMailExamine.setUserPlayerId(batchPlayerQueryPO.getUserPlayerId());
                    if (jsonMap.isEmpty()) {
                        gameMailExamine.setMailRewardJson(gameMailExamine.getMailRewardJson());
                    } else {
                        gameMailExamine.setMailRewardJson((String)jsonMap.get(batchPlayerQueryPO.getServerId()));
                    }
                    this.mailApiSending(gameMailExamine);
                }
            }
            catch (Exception e) {
                log.error("\u8c03\u7528\u670d\u52a1\u7aef\u53d1\u9001\u90ae\u4ef6\u7ebf\u7a0b\u6c60\u5f02\u5e38: \u5165\u53c2={}", (Object)gameMailExamine);
                String mailFailContent = "\u8c03\u7528\u670d\u52a1\u7aef\u53d1\u9001\u90ae\u4ef6\u7ebf\u7a0b\u6c60\u5f02\u5e38; \u90ae\u4ef6\u8868id=" + gameMailExamine.getMailId();
                this.examineUpdateMail(gameMailExamine.getMailId(), mailFailContent, MailStateEnums.FAIL.getValue(), gameMailExamine.getExamineContent());
            }
            return 1;
        });
    }

    public void crossBarHandle(GameMailExamine gameMailExamine) {
        String districtServer = "";
        List<String> serverList = Arrays.asList(gameMailExamine.getUserPlayerId().split("\n"));
        for (int i = 0; i < serverList.size(); ++i) {
            if (serverList.get(i).contains("-")) {
                String poleHead = serverList.get(i).substring(0, serverList.get(i).indexOf("-"));
                String poleTail = serverList.get(i).substring(poleHead.length() + 1, serverList.get(i).length());
                String commaHead = poleTail.substring(0, poleTail.indexOf(","));
                String commaTail = poleTail.substring(commaHead.length() + 1, poleTail.length());
                String serverIdString = "";
                for (int z = Integer.valueOf(poleHead).intValue(); z < Integer.valueOf(commaHead) + 1; ++z) {
                    serverIdString = serverIdString + z + "," + commaTail + "\n";
                }
                districtServer = districtServer + serverIdString;
                continue;
            }
            districtServer = districtServer + serverList.get(i) + "\n";
        }
        gameMailExamine.setUserPlayerId(districtServer);
    }

    public void mailApiSending(GameMailExamine gameMailExamine) {
        List userPlayerIdList = this.serverIdHandle(gameMailExamine);
        GameMailApiPO gameMailApiPO = new GameMailApiPO();
        gameMailApiPO.setServiceId(Integer.valueOf(gameMailExamine.getServerId()));
        gameMailApiPO.setTitle(gameMailExamine.getMailTitle());
        gameMailApiPO.setContent(gameMailExamine.getMailContent());
        gameMailApiPO.setCheckOnce(Boolean.valueOf(BaseYesNoEnums.getDescByType((String)gameMailExamine.getMailCheckOnce())));
        gameMailApiPO.setExpireTime(Long.valueOf(gameMailExamine.getMailExpireTime().getTime()));
        gameMailApiPO.setFilterAfterPostCreate(Boolean.valueOf(BaseYesNoEnums.getDescByType((String)gameMailExamine.getMailFilterAfterPostCreate())));
        gameMailApiPO.setReceiveConditionJson(gameMailExamine.getMailReceiveConditionJson());
        gameMailApiPO.setValidConditionJson(gameMailExamine.getMailValidConditionJson());
        gameMailApiPO.setAppointedPlayerIds(userPlayerIdList);
        gameMailApiPO.setMailBox(MailTypeEnums.getDescByValue((Integer)gameMailExamine.getMailType()));
        gameMailApiPO.setBackStageMailId(gameMailExamine.getMailServerId());
        if (StringUtils.isEmpty((String)gameMailExamine.getMailRewardJson())) {
            gameMailApiPO.setRewardJson("");
        } else {
            gameMailApiPO.setRewardJson(gameMailExamine.getMailRewardJson());
        }
        GameMailApiVO gameMailApiVO = new GameMailApiVO();
        Integer serviceId = Integer.valueOf(gameMailExamine.getServerId());
        RearServerConfig RearServerConfig2 = this.rearServerServiceImpl.serverIdQuery(String.valueOf(serviceId));
        if (RearServerConfig2 == null || StringUtils.isEmpty((String)RearServerConfig2.getServerIp())) {
            log.error("\u6b64\u670d\u52a1\u5668\u65e0ip\u4e0a\u62a5\u4fe1\u606f\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458: \u670d\u52a1\u5668Id={}", (Object)gameMailExamine.getServerId());
            String mailFailContent = "\u670d\u52a1\u5668Id: " + gameMailExamine.getServerId() + "; \u6b64\u670d\u52a1\u5668\u65e0ip\u4e0a\u62a5\u4fe1\u606f,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458";
            this.examineUpdateMail(gameMailExamine.getMailId(), mailFailContent, MailStateEnums.FAIL.getValue(), gameMailExamine.getExamineContent());
            this.mailLog(gameMailApiPO, mailFailContent, gameMailExamine, MailStateEnums.FAIL.getValue());
            return;
        }
        String serverIp = RearServerConfig2.getServerIp();
        Integer serverPort = RearServerConfig2.getServerPort();
        String visitUrl = "http://" + serverIp + ":" + serverPort + "/sendGroupMail";
        try {
            log.info("\u8c03\u7528\u53d1\u9001\u90ae\u4ef6\u63a5\u53e3: url={},\u5165\u53c2={}", (Object)visitUrl, (Object)gameMailApiPO);
            RestTemplate restTemplate = new RestTemplate();
            HttpHeaders headers = new HttpHeaders();
            MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
            headers.setContentType(type);
            headers.add("Accept", MediaType.APPLICATION_JSON.toString());
            HttpEntity formEntity = new HttpEntity((Object)gameMailApiPO, (MultiValueMap)headers);
            gameMailApiVO = (GameMailApiVO)restTemplate.postForObject(visitUrl, (Object)formEntity, GameMailApiVO.class, new Object[0]);
            log.info("\u8c03\u7528\u53d1\u9001\u90ae\u4ef6\u63a5\u53e3: \u51fa\u53c2={}", (Object)gameMailApiVO);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u53d1\u9001\u90ae\u4ef6\u63a5\u53e3\u5f02\u5e38: e\u5f02\u5e38={}", (Throwable)e);
            log.error("\u8c03\u7528\u53d1\u9001\u90ae\u4ef6\u63a5\u53e3\u5f02\u5e38: url={},\u5165\u53c2={}", (Object)visitUrl, (Object)gameMailExamine);
            String mailFailContent = "\u8c03\u7528\u53d1\u9001\u90ae\u4ef6\u63a5\u53e3\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458; \u90ae\u4ef6\u8868id=" + gameMailExamine.getMailId();
            this.examineUpdateMail(gameMailExamine.getMailId(), mailFailContent, MailStateEnums.FAIL.getValue(), gameMailExamine.getExamineContent());
            this.mailLog(gameMailApiPO, mailFailContent, gameMailExamine, MailStateEnums.FAIL.getValue());
            return;
        }
        if (gameMailApiVO == null || gameMailApiVO.getCode() != BaseSuccessFailEnums.SUCCESS.getValue()) {
            log.error("\u53d1\u9001\u90ae\u4ef6\u5931\u8d25: url={},\u5165\u53c2={},\u51fa\u53c2={}", new Object[]{visitUrl, gameMailExamine, gameMailApiVO});
            String mailFailContent = "\u53d1\u9001\u90ae\u4ef6\u5931\u8d25,\u8bf7\u7a0d\u540e\u518d\u8bd5; \u90ae\u4ef6\u8868id=" + gameMailExamine.getMailId();
            this.examineUpdateMail(gameMailExamine.getMailId(), mailFailContent, MailStateEnums.FAIL.getValue(), gameMailExamine.getExamineContent());
            this.mailLog(gameMailApiPO, JSONObject.toJSONString((Object)gameMailApiVO, (JSONWriter.Feature[])new JSONWriter.Feature[0]), gameMailExamine, MailStateEnums.FAIL.getValue());
            return;
        }
        this.examineUpdateMail(gameMailExamine.getMailId(), null, MailStateEnums.SUCCESS.getValue(), gameMailExamine.getExamineContent());
        this.mailLog(gameMailApiPO, JSONObject.toJSONString((Object)gameMailApiVO, (JSONWriter.Feature[])new JSONWriter.Feature[0]), gameMailExamine, MailStateEnums.SUCCESS.getValue());
    }

    public List<String> serverIdHandle(GameMailExamine gameMailExamine) {
        ArrayList<String> userPlayerIdList = new ArrayList<String>();
        List<Object> playerIdStringList = new ArrayList();
        if (!StringUtils.isEmpty((String)gameMailExamine.getUserPlayerId())) {
            playerIdStringList = Arrays.asList(gameMailExamine.getUserPlayerId().split("\n"));
        }
        String intercept = "|";
        String roleId = "";
        for (int i = 0; i < playerIdStringList.size(); ++i) {
            roleId = ((String)playerIdStringList.get(i)).substring(0, ((String)playerIdStringList.get(i)).indexOf(intercept));
            userPlayerIdList.add(roleId);
        }
        return userPlayerIdList;
    }

    public void examineUpdateMail(Long mailId, String mailFailContent, String mailState, String examineContent) {
        GameMail gameMail = new GameMail();
        gameMail.setId(mailId);
        gameMail.setExamineTime(new Date());
        gameMail.setMailFailContent(mailFailContent);
        gameMail.setExamineContent(examineContent);
        gameMail.setMailState(mailState);
        this.gameMailServiceImpl.examineUpdateMail(gameMail);
    }

    public void mailLog(GameMailApiPO gameMailApiPO, String exoticGinseng, GameMailExamine gameMailExamine, String mailState) {
        GameMailSendLog gameMailSendLog = new GameMailSendLog();
        gameMailSendLog.setMailId(gameMailExamine.getMailId());
        gameMailSendLog.setSendType(mailSendTypeEnums.IMMEDIATELY_SEND.getValue());
        gameMailSendLog.setEnteringGinseng(JSONObject.toJSONString((Object)gameMailApiPO, (JSONWriter.Feature[])new JSONWriter.Feature[0]));
        gameMailSendLog.setExoticGinseng(exoticGinseng);
        gameMailSendLog.setMailState(mailState);
        gameMailSendLog.setMailInternalMark(String.valueOf(gameMailExamine.getMailInternalMark()));
        gameMailSendLog.setMailServerId(gameMailExamine.getMailServerId());
        this.gameMailSendLogServiceImpl.insertGameMailSendLog(gameMailSendLog);
    }

    public Future<Integer> mailReducePropFuture(GameMailExamine gameMailExamine) {
        return executorService.submit(() -> {
            Integer state = 0;
            try {
                this.crossBarHandle(gameMailExamine);
                HashMap<String, String> jsonMap = new HashMap<String, String>();
                if (SendingTypeEnums.CUSTOM_AND_USER_PLAYER_ID.getValue() == gameMailExamine.getMailSendingType() || SendingTypeEnums.CUSTOM_AND_USER_ACCOUNT.getValue() == gameMailExamine.getMailSendingType()) {
                    List<String> serverList = Arrays.asList(gameMailExamine.getUserPlayerId().split("\n"));
                    String head = "";
                    int appointIndex = 0;
                    for (int i = 0; i < serverList.size(); ++i) {
                        appointIndex = serverList.get(i).indexOf(",[");
                        head = head + serverList.get(i).substring(0, appointIndex) + "\n";
                        List<String> dataList = Arrays.asList(serverList.get(i).split(","));
                        jsonMap.put(dataList.get(0), serverList.get(i).substring(serverList.get(i).lastIndexOf(",[") + 1));
                    }
                    gameMailExamine.setUserPlayerId(head);
                }
                List batchPlayerQueryPOList = this.interfaceSendUtils.manyServerPlayerHandle(gameMailExamine.getUserPlayerId());
                for (BatchPlayerQueryPO batchPlayerQueryPO : batchPlayerQueryPOList) {
                    gameMailExamine.setServerId(batchPlayerQueryPO.getServerId());
                    gameMailExamine.setUserPlayerId(batchPlayerQueryPO.getUserPlayerId());
                    List userPlayerIdList = this.serverIdHandle(gameMailExamine);
                    String visitUrl = this.interfaceSendUtils.serverUrlAddress(gameMailExamine.getServerId(), "sendDeductMail");
                    InterfaceSendPO interfaceSendPO = new InterfaceSendPO();
                    interfaceSendPO.setVisitUrl(visitUrl);
                    interfaceSendPO.setInterfaceDescribe("\u6263\u8d44\u6e90\u90ae\u4ef6");
                    HashMap<String, String> suppliedMap = new HashMap<String, String>();
                    suppliedMap.put("serviceId", gameMailExamine.getServerId());
                    suppliedMap.put("mailBox", MailTypeEnums.ORDINARY.getDesc());
                    suppliedMap.put("title", gameMailExamine.getMailTitle());
                    suppliedMap.put("content", gameMailExamine.getMailContent());
                    suppliedMap.put("playerId", (String)userPlayerIdList.get(0));
                    suppliedMap.put("deductRewardJson", gameMailExamine.getMailRewardJson());
                    interfaceSendPO.setSuppliedMap(suppliedMap);
                    HashMap<String, String> printMap = new HashMap<String, String>();
                    printMap.put("serviceId", gameMailExamine.getServerId());
                    printMap.put("playerId", (String)userPlayerIdList.get(0));
                    printMap.put("deductRewardJson", gameMailExamine.getMailRewardJson());
                    interfaceSendPO.setPrintMap(printMap);
                    InterfaceSendVO interfaceSendVO = this.interfaceSendUtils.interfaceSend(interfaceSendPO);
                    if (interfaceSendVO != null && interfaceSendVO.getCode().equals(BaseSuccessFailEnums.SUCCESS.getValue())) continue;
                    String mailFailContent = "\u53d1\u9001\u90ae\u4ef6\u5931\u8d25,\u8bf7\u7a0d\u540e\u518d\u8bd5; \u90ae\u4ef6\u8868id=" + gameMailExamine.getMailId();
                    this.mailReducePropLog(gameMailExamine, JSONObject.toJSONString((Object)interfaceSendVO, (JSONWriter.Feature[])new JSONWriter.Feature[0]), MailStateEnums.FAIL.getValue());
                    this.updateMailReduceProp(gameMailExamine, interfaceSendVO.getMsg(), MailStateEnums.FAIL.getValue());
                    Integer n = state;
                    Integer n2 = state = Integer.valueOf(state + 1);
                }
            }
            catch (Exception e) {
                log.error("\u8c03\u7528\u670d\u52a1\u7aef\u53d1\u9001\u6263\u9664\u90ae\u4ef6\u7ebf\u7a0b\u6c60\u5f02\u5e38: \u5165\u53c2={}", (Object)gameMailExamine);
                String mailFailContent = "\u8c03\u7528\u670d\u52a1\u7aef\u53d1\u9001\u6263\u9664\u90ae\u4ef6\u7ebf\u7a0b\u6c60\u5f02\u5e38; \u5ba1\u6838\u90ae\u4ef6\u8868id=" + gameMailExamine.getMailId();
                this.mailReducePropLog(gameMailExamine, mailFailContent, MailStateEnums.FAIL.getValue());
                this.updateMailReduceProp(gameMailExamine, mailFailContent, MailStateEnums.FAIL.getValue());
            }
            if (state == 0) {
                this.updateMailReduceProp(gameMailExamine, MailStateEnums.SUCCESS.getValue(), MailStateEnums.SUCCESS.getValue());
                this.mailReducePropLog(gameMailExamine, null, MailStateEnums.SUCCESS.getValue());
            } else {
                this.updateMailReduceProp(gameMailExamine, "\u6b64\u90ae\u4ef6\u5b58\u5728\u5931\u8d25\u6761\u6570", MailStateEnums.FAIL.getValue());
            }
            return 1;
        });
    }

    public void updateMailReduceProp(GameMailExamine gameMailExamine, String mailFailContent, String mailState) {
        GameMailReduceProp gameMailReduceProp = new GameMailReduceProp();
        gameMailReduceProp.setId(gameMailExamine.getMailId());
        gameMailReduceProp.setExamineTime(new Date());
        gameMailReduceProp.setMailFailContent(mailFailContent);
        gameMailReduceProp.setExamineContent(gameMailExamine.getExamineContent());
        gameMailReduceProp.setMailState(mailState);
        this.gameMailReducePropServiceImpl.updateGameMailReduceProp(gameMailReduceProp);
    }

    public void mailReducePropLog(GameMailExamine gameMailExamine, String exoticGinseng, String mailState) {
        GameMailSendLog gameMailSendLog = new GameMailSendLog();
        gameMailSendLog.setMailId(gameMailExamine.getMailId());
        gameMailSendLog.setSendType(mailSendTypeEnums.IMMEDIATELY_SEND.getValue());
        gameMailSendLog.setEnteringGinseng(JSONObject.toJSONString((Object)gameMailExamine, (JSONWriter.Feature[])new JSONWriter.Feature[0]));
        gameMailSendLog.setExoticGinseng(exoticGinseng);
        gameMailSendLog.setMailState(mailState);
        gameMailSendLog.setMailInternalMark(String.valueOf(gameMailExamine.getMailInternalMark()));
        gameMailSendLog.setMailWay(Integer.valueOf(MailWayEnums.BUTTON_UP.getValue()));
        this.gameMailSendLogServiceImpl.insertGameMailSendLog(gameMailSendLog);
    }

    public Future<Integer> mailDeleteFuture(GameMailExamine gameMailExamine) {
        return executorService.submit(() -> {
            this.crossBarHandle(gameMailExamine);
            HashMap<String, String> jsonMap = new HashMap<String, String>();
            if (SendingTypeEnums.CUSTOM_AND_USER_PLAYER_ID.getValue() == gameMailExamine.getMailSendingType() || SendingTypeEnums.CUSTOM_AND_USER_ACCOUNT.getValue() == gameMailExamine.getMailSendingType()) {
                List<String> serverList = Arrays.asList(gameMailExamine.getUserPlayerId().split("\n"));
                String head = "";
                int appointIndex = 0;
                for (int i = 0; i < serverList.size(); ++i) {
                    appointIndex = serverList.get(i).indexOf(",[");
                    head = head + serverList.get(i).substring(0, appointIndex) + "\n";
                    List<String> dataList = Arrays.asList(serverList.get(i).split(","));
                    jsonMap.put(dataList.get(0), serverList.get(i).substring(serverList.get(i).lastIndexOf(",[") + 1));
                }
                gameMailExamine.setUserPlayerId(head);
            }
            int mark = 0;
            try {
                List batchPlayerQueryPOList = this.interfaceSendUtils.manyServerPlayerHandle(gameMailExamine.getUserPlayerId());
                for (BatchPlayerQueryPO batchPlayerQueryPO : batchPlayerQueryPOList) {
                    gameMailExamine.setServerId(batchPlayerQueryPO.getServerId());
                    String visitUrl = this.interfaceSendUtils.serverUrlAddress(gameMailExamine.getServerId(), "stopAndDelGroupMail");
                    InterfaceSendPO interfaceSendPO = new InterfaceSendPO();
                    interfaceSendPO.setVisitUrl(visitUrl);
                    interfaceSendPO.setInterfaceDescribe("\u5220\u9664\u9886\u53d6\u7fa4\u53d1\u90ae\u4ef6\u7684\u73a9\u5bb6\u90ae\u4ef6");
                    HashMap<String, String> suppliedMap = new HashMap<String, String>();
                    suppliedMap.put("serviceId", batchPlayerQueryPO.getServerId());
                    suppliedMap.put("backStageMailId", gameMailExamine.getMailServerId());
                    interfaceSendPO.setSuppliedMap(suppliedMap);
                    HashMap<String, String> printMap = new HashMap<String, String>();
                    printMap.put("serviceId", batchPlayerQueryPO.getServerId());
                    printMap.put("backStageMailId", gameMailExamine.getMailServerId());
                    interfaceSendPO.setPrintMap(printMap);
                    InterfaceSendVO interfaceSendVO = this.interfaceSendUtils.interfaceSend(interfaceSendPO);
                    if (interfaceSendVO != null && interfaceSendVO.getCode().equals(BaseSuccessFailEnums.SUCCESS.getValue())) continue;
                    this.mailDeleteLog(gameMailExamine, JSONObject.toJSONString((Object)interfaceSendVO, (JSONWriter.Feature[])new JSONWriter.Feature[0]), MailStateEnums.FAIL.getValue(), Integer.valueOf(MailWayEnums.DELETE_MAIL.getValue()));
                    ++mark;
                }
            }
            catch (Exception e) {
                log.error("\u8c03\u7528\u670d\u52a1\u7aef \u5220\u9664\u9886\u53d6\u7fa4\u53d1\u90ae\u4ef6\u7684\u73a9\u5bb6\u90ae\u4ef6 \u7ebf\u7a0b\u6c60\u5f02\u5e38: \u5165\u53c2={}", (Object)gameMailExamine);
                String mailFailContent = "\u8c03\u7528\u670d\u52a1\u7aef \u5220\u9664\u9886\u53d6\u7fa4\u53d1\u90ae\u4ef6\u7684\u73a9\u5bb6\u90ae\u4ef6 \u7ebf\u7a0b\u6c60\u5f02\u5e38; \u5ba1\u6838\u90ae\u4ef6\u8868id=" + gameMailExamine.getMailId();
                this.mailDeleteLog(gameMailExamine, mailFailContent, MailStateEnums.FAIL.getValue(), Integer.valueOf(MailWayEnums.DELETE_MAIL.getValue()));
                this.updateMailDelete(gameMailExamine, mailFailContent, MailStateEnums.FAIL.getValue());
            }
            if (mark == 0) {
                this.mailDeleteLog(gameMailExamine, null, MailStateEnums.SUCCESS.getValue(), Integer.valueOf(MailWayEnums.DELETE_MAIL.getValue()));
                this.updateMailDelete(gameMailExamine, MailStateEnums.SUCCESS.getValue(), MailStateEnums.SUCCESS.getValue());
            } else {
                this.updateMailDelete(gameMailExamine, "\u6b64\u90ae\u4ef6\u5b58\u5728\u5931\u8d25\u6761\u6570", MailStateEnums.FAIL.getValue());
            }
            return 1;
        });
    }

    public Future<Integer> mailCloseFuture(GameMailExamine gameMailExamine) {
        return executorService.submit(() -> {
            int mark = 0;
            try {
                List batchPlayerQueryPOList = this.interfaceSendUtils.manyServerPlayerHandle(gameMailExamine.getUserPlayerId());
                for (BatchPlayerQueryPO batchPlayerQueryPO : batchPlayerQueryPOList) {
                    gameMailExamine.setServerId(batchPlayerQueryPO.getServerId());
                    String visitUrl = this.interfaceSendUtils.serverUrlAddress(gameMailExamine.getServerId(), "stopGroupMail");
                    InterfaceSendPO interfaceSendPO = new InterfaceSendPO();
                    interfaceSendPO.setVisitUrl(visitUrl);
                    interfaceSendPO.setInterfaceDescribe("\u5173\u95ed\u7fa4\u53d1\u90ae\u4ef6");
                    HashMap<String, String> suppliedMap = new HashMap<String, String>();
                    suppliedMap.put("serviceId", batchPlayerQueryPO.getServerId());
                    suppliedMap.put("backStageMailId", gameMailExamine.getMailServerId());
                    interfaceSendPO.setSuppliedMap(suppliedMap);
                    HashMap<String, String> printMap = new HashMap<String, String>();
                    printMap.put("serviceId", batchPlayerQueryPO.getServerId());
                    printMap.put("backStageMailId", gameMailExamine.getMailServerId());
                    interfaceSendPO.setPrintMap(printMap);
                    InterfaceSendVO interfaceSendVO = this.interfaceSendUtils.interfaceSend(interfaceSendPO);
                    if (interfaceSendVO != null && interfaceSendVO.getCode().equals(BaseSuccessFailEnums.SUCCESS.getValue())) continue;
                    this.mailDeleteLog(gameMailExamine, JSONObject.toJSONString((Object)interfaceSendVO, (JSONWriter.Feature[])new JSONWriter.Feature[0]), MailStateEnums.FAIL.getValue(), Integer.valueOf(MailWayEnums.CLOSE_MAIL.getValue()));
                    ++mark;
                }
            }
            catch (Exception e) {
                log.error("\u8c03\u7528\u670d\u52a1\u7aef \u5173\u95ed\u7fa4\u53d1\u90ae\u4ef6 \u7ebf\u7a0b\u6c60\u5f02\u5e38: \u5165\u53c2={}", (Object)gameMailExamine);
                String mailFailContent = "\u8c03\u7528\u670d\u52a1\u7aef \u5173\u95ed\u7fa4\u53d1\u90ae\u4ef6 \u7ebf\u7a0b\u6c60\u5f02\u5e38; \u5ba1\u6838\u90ae\u4ef6\u8868id=" + gameMailExamine.getMailId();
                this.mailDeleteLog(gameMailExamine, mailFailContent, MailStateEnums.FAIL.getValue(), Integer.valueOf(MailWayEnums.CLOSE_MAIL.getValue()));
                this.updateMailDelete(gameMailExamine, mailFailContent, MailStateEnums.FAIL.getValue());
            }
            if (mark == 0) {
                this.mailDeleteLog(gameMailExamine, null, MailStateEnums.SUCCESS.getValue(), Integer.valueOf(MailWayEnums.CLOSE_MAIL.getValue()));
                this.updateMailDelete(gameMailExamine, MailStateEnums.SUCCESS.getValue(), MailStateEnums.SUCCESS.getValue());
            } else {
                this.updateMailDelete(gameMailExamine, "\u6b64\u90ae\u4ef6\u5b58\u5728\u5931\u8d25\u6761\u6570", MailStateEnums.FAIL.getValue());
            }
            return 1;
        });
    }

    public void updateMailDelete(GameMailExamine gameMailExamine, String mailFailContent, String mailState) {
        GameMailDelete gameMailDelete = new GameMailDelete();
        gameMailDelete.setMailServerId(gameMailExamine.getMailServerId());
        gameMailDelete.setExamineTime(new Date());
        gameMailDelete.setMailFailContent(mailFailContent);
        gameMailDelete.setExamineContent(gameMailExamine.getExamineContent());
        gameMailDelete.setMailState(mailState);
        this.gameMailDeleteServiceImpl.updateGameMailDeleteToExamine(gameMailDelete);
    }

    public void mailDeleteLog(GameMailExamine gameMailExamine, String exoticGinseng, String mailState, Integer mailWay) {
        GameMailSendLog gameMailSendLog = new GameMailSendLog();
        gameMailSendLog.setMailId(gameMailExamine.getMailId());
        gameMailSendLog.setMailServerId(gameMailExamine.getMailServerId());
        gameMailSendLog.setSendType(mailSendTypeEnums.IMMEDIATELY_SEND.getValue());
        gameMailSendLog.setEnteringGinseng(JSONObject.toJSONString((Object)gameMailExamine, (JSONWriter.Feature[])new JSONWriter.Feature[0]));
        gameMailSendLog.setExoticGinseng(exoticGinseng);
        gameMailSendLog.setMailState(mailState);
        gameMailSendLog.setMailInternalMark(String.valueOf(gameMailExamine.getMailInternalMark()));
        gameMailSendLog.setMailWay(mailWay);
        this.gameMailSendLogServiceImpl.insertGameMailSendLog(gameMailSendLog);
    }
}

