/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.service.impl.operate.mail;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ruoyi.common.core.exception.ServiceException;
import com.ruoyi.common.core.utils.DateUtils;
import com.ruoyi.common.core.utils.StringUtils;
import com.ruoyi.common.security.utils.SecurityUtils;
import com.ruoyi.rearend.domain.GameMail;
import com.ruoyi.rearend.domain.GameMailDelete;
import com.ruoyi.rearend.domain.GameMailExamine;
import com.ruoyi.rearend.domain.vo.operate.mail.GameMailDeleteQueryVO;
import com.ruoyi.rearend.enums.operate.MailDeleteTypeEnums;
import com.ruoyi.rearend.enums.operate.MailExamineStateEnums;
import com.ruoyi.rearend.enums.operate.MailStateEnums;
import com.ruoyi.rearend.enums.operate.MailWayEnums;
import com.ruoyi.rearend.mapper.operate.mail.GameMailDeleteMapper;
import com.ruoyi.rearend.mapper.operate.mail.GameMailExamineMapper;
import com.ruoyi.rearend.service.impl.operate.mail.GameMailServiceImpl;
import com.ruoyi.rearend.service.operate.mail.IGameMailDeleteService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GameMailDeleteServiceImpl
implements IGameMailDeleteService {
    @Autowired
    private GameMailDeleteMapper gameMailDeleteMapper;
    @Autowired
    private GameMailServiceImpl gameMailServiceImpl;
    @Autowired
    private GameMailExamineMapper gameMailExamineMapper;

    public GameMailDelete selectGameMailDeleteById(Long Id) {
        return this.gameMailDeleteMapper.selectGameMailDeleteById(Id);
    }

    public List<GameMailDelete> selectGameMailDeleteList(GameMailDelete gameMailDelete) {
        return this.gameMailDeleteMapper.selectGameMailDeleteList(gameMailDelete);
    }

    @Transactional(rollbackFor={Exception.class})
    public int insertGameMailDelete(GameMailDelete gameMailDelete) {
        gameMailDelete.setMailState(MailStateEnums.AUDIT.getValue());
        gameMailDelete.setCreateTime(DateUtils.getNowDate());
        this.gameMailDeleteMapper.insertGameMailDelete(gameMailDelete);
        String operName = SecurityUtils.getUsername();
        GameMail gameMail = this.gameMailServiceImpl.queryMailServerId(gameMailDelete.getMailServerId());
        GameMailExamine gameMailExamine = new GameMailExamine();
        BeanUtils.copyProperties((Object)gameMail, (Object)gameMailExamine);
        gameMailExamine.setId(null);
        gameMailExamine.setExamineContent(null);
        gameMailExamine.setExamineTime(null);
        gameMailExamine.setMailId(gameMail.getId());
        gameMailExamine.setExamineState(MailExamineStateEnums.AUDIT.getValue());
        gameMailExamine.setCreateBy(operName);
        gameMailExamine.setCreateTime(DateUtils.getNowDate());
        if (MailDeleteTypeEnums.DELETE_MAIL.getValue() == gameMailDelete.getMailDeleteType()) {
            gameMailExamine.setMailWay(Integer.valueOf(MailWayEnums.DELETE_MAIL.getValue()));
        } else {
            gameMailExamine.setMailWay(Integer.valueOf(MailWayEnums.CLOSE_MAIL.getValue()));
        }
        this.gameMailExamineMapper.insertGameMailExamine(gameMailExamine);
        return 1;
    }

    public GameMailDeleteQueryVO detection(String mailServerId) {
        GameMail gameMail = this.gameMailServiceImpl.queryMailServerId(mailServerId);
        if (gameMail == null || StringUtils.isEmpty((String)gameMail.getMailState())) {
            throw new ServiceException("\u6682\u672a\u67e5\u8be2\u5230\u6b64\u90ae\u4ef6,\u8bf7\u786e\u4fdd\u6b64\u90ae\u4ef6\u4e3a \u5916\u90e8\u90ae\u4ef6\u4e14\u53d1\u9001\u72b6\u6001\u4e3a\u6210\u529f!");
        }
        GameMailDeleteQueryVO gameMailDeleteQueryVO = new GameMailDeleteQueryVO();
        BeanUtils.copyProperties((Object)gameMail, (Object)gameMailDeleteQueryVO);
        JSONArray list = JSON.parseArray((String)gameMail.getMailPropJson());
        ArrayList<Map> mailPropJsonList = new ArrayList<Map>();
        for (Object object : list) {
            Map ret = (Map)object;
            mailPropJsonList.add(ret);
        }
        gameMailDeleteQueryVO.setMailPropJsonList(mailPropJsonList);
        return gameMailDeleteQueryVO;
    }

    public int updateGameMailDeleteToExamine(GameMailDelete gameMailDelete) {
        String operName = SecurityUtils.getUsername();
        gameMailDelete.setUpdateBy(operName);
        gameMailDelete.setUpdateTime(new Date());
        return this.gameMailDeleteMapper.updateGameMailDeleteToExamine(gameMailDelete);
    }
}

