/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.service.impl.operate.giftpack;

import com.ruoyi.common.core.exception.ServiceException;
import com.ruoyi.common.core.utils.DateUtils;
import com.ruoyi.common.security.utils.SecurityUtils;
import com.ruoyi.rearend.domain.RearGiftPack;
import com.ruoyi.rearend.domain.po.game.giftpack.GiftPackBatchAddPO;
import com.ruoyi.rearend.domain.vo.game.giftpack.GiftPackBatchVO;
import com.ruoyi.rearend.enums.ServerEnums;
import com.ruoyi.rearend.mapper.operate.giftpack.RearGiftPackMapper;
import com.ruoyi.rearend.service.operate.giftpack.IRearGiftPackService;
import com.ruoyi.rearend.utils.InterfaceSendUtils;
import com.ruoyi.rearend.utils.RandomCodeUtils;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RearGiftPackServiceImpl
implements IRearGiftPackService {
    @Autowired
    private RearGiftPackMapper rearGiftPackMapper;
    @Autowired
    private InterfaceSendUtils interfaceSendUtils;

    public RearGiftPack selectRearGiftPackById(Long Id) {
        return this.rearGiftPackMapper.selectRearGiftPackById(Id);
    }

    public List<RearGiftPack> selectRearGiftPackList(RearGiftPack rearGiftPack) {
        return this.rearGiftPackMapper.selectRearGiftPackList(rearGiftPack);
    }

    public int insertRearGiftPack(RearGiftPack rearGiftPack) {
        Integer number = this.rearGiftPackMapper.giftPackExist(rearGiftPack.getGiftPackCode());
        if (number != 0) {
            throw new ServiceException("\u6b64\u793c\u5305\u7801\u5df2\u5b58\u5728!");
        }
        if (!ServerEnums.ALL.getValue().equals(rearGiftPack.getDistrictServer())) {
            this.interfaceSendUtils.serverSlicing(rearGiftPack.getDistrictServer());
        }
        rearGiftPack.setCreateBy(SecurityUtils.getUsername());
        rearGiftPack.setCreateTime(DateUtils.getNowDate());
        return this.rearGiftPackMapper.insertRearGiftPack(rearGiftPack);
    }

    public int updateRearGiftPack(RearGiftPack rearGiftPack) {
        if (!ServerEnums.ALL.getValue().equals(rearGiftPack.getDistrictServer())) {
            this.interfaceSendUtils.serverSlicing(rearGiftPack.getDistrictServer());
        }
        rearGiftPack.setUpdateTime(DateUtils.getNowDate());
        return this.rearGiftPackMapper.updateRearGiftPack(rearGiftPack);
    }

    public int deleteRearGiftPackByIds(Long[] Ids) {
        return this.rearGiftPackMapper.deleteRearGiftPackByIds(Ids);
    }

    public int deleteRearGiftPackById(Long Id) {
        return this.rearGiftPackMapper.deleteRearGiftPackById(Id);
    }

    @Transactional(rollbackFor={Exception.class})
    public GiftPackBatchVO giftPackBatch(GiftPackBatchAddPO giftPackBatchAddPO) {
        GiftPackBatchVO giftPackBatchVO = new GiftPackBatchVO();
        List batchGiftPackList = this.batchGiftPack(giftPackBatchAddPO.getGiftPackLength().intValue(), giftPackBatchAddPO.getGiftPackNumber().intValue());
        if (batchGiftPackList == null || batchGiftPackList.size() == 0) {
            giftPackBatchVO.setSuccessNumber(Integer.valueOf(0));
            giftPackBatchVO.setFailNumber(giftPackBatchAddPO.getGiftPackNumber());
            return giftPackBatchVO;
        }
        String exchangeIdString = "";
        ArrayList<RearGiftPack> rearGiftPackList = new ArrayList<RearGiftPack>();
        for (int i = 0; i < batchGiftPackList.size(); ++i) {
            RearGiftPack rearGiftPack = new RearGiftPack();
            BeanUtils.copyProperties((Object)giftPackBatchAddPO, (Object)rearGiftPack);
            rearGiftPack.setGiftPackCode((String)batchGiftPackList.get(i));
            rearGiftPack.setCreateBy(SecurityUtils.getUsername());
            rearGiftPack.setCreateTime(DateUtils.getNowDate());
            rearGiftPackList.add(rearGiftPack);
            exchangeIdString = exchangeIdString + "\n" + (String)batchGiftPackList.get(i);
        }
        giftPackBatchVO.setGiftPackCodeString(exchangeIdString);
        this.rearGiftPackMapper.batchGiftPackCode(rearGiftPackList);
        giftPackBatchVO.setSuccessNumber(Integer.valueOf(batchGiftPackList.size()));
        giftPackBatchVO.setFailNumber(Integer.valueOf(giftPackBatchAddPO.getGiftPackNumber() - batchGiftPackList.size()));
        return giftPackBatchVO;
    }

    public List<String> batchGiftPack(int stringLength, int exchangeNumber) {
        ArrayList<String> tableList = new ArrayList();
        List exchangeIdList = RandomCodeUtils.getRandomString((int)stringLength, (int)exchangeNumber);
        List exchangeIdSqlList = this.rearGiftPackMapper.queryGirfPackIdList();
        if (exchangeIdSqlList == null || exchangeIdSqlList.size() <= 0) {
            tableList = exchangeIdList;
            return tableList;
        }
        ArrayList exchangeIdExistList = new ArrayList();
        for (String str : exchangeIdList) {
            if (exchangeIdSqlList.contains(str)) continue;
            tableList.add(str);
        }
        return tableList;
    }
}

