/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.service.impl.operate.event;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ruoyi.common.core.utils.DateUtils;
import com.ruoyi.common.core.utils.StringUtils;
import com.ruoyi.common.security.utils.SecurityUtils;
import com.ruoyi.rearend.domain.RearExcitingEvents;
import com.ruoyi.rearend.domain.RearServerConfig;
import com.ruoyi.rearend.domain.po.InterfaceSendPO;
import com.ruoyi.rearend.domain.po.operate.InterfaceHandlePO;
import com.ruoyi.rearend.domain.po.operate.event.RearExcitingEventsAddPO;
import com.ruoyi.rearend.domain.po.operate.event.RearExcitingEventsForeignPO;
import com.ruoyi.rearend.domain.po.operate.event.RearExcitingEventsListPO;
import com.ruoyi.rearend.domain.vo.InterfaceCallVO;
import com.ruoyi.rearend.domain.vo.InterfaceSendVO;
import com.ruoyi.rearend.domain.vo.operate.event.ExcitingEventsDetailsVO;
import com.ruoyi.rearend.enums.OperateMarkEnums;
import com.ruoyi.rearend.enums.operate.EventsOperateStateEnums;
import com.ruoyi.rearend.enums.operate.EventsStateEnums;
import com.ruoyi.rearend.mapper.operate.event.RearExcitingEventsMapper;
import com.ruoyi.rearend.service.operate.event.IRearExcitingEventsService;
import com.ruoyi.rearend.utils.InterfaceSendUtils;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.DigestUtils;

@Service
public class RearExcitingEventsServiceImpl
implements IRearExcitingEventsService {
    @Autowired
    private RearExcitingEventsMapper rearExcitingEventsMapper;
    @Autowired
    private InterfaceSendUtils interfaceSendUtils;
    private static final Logger log = LoggerFactory.getLogger(RearExcitingEventsServiceImpl.class);

    public ExcitingEventsDetailsVO selectRearExcitingEventsById(Long Id) {
        ExcitingEventsDetailsVO excitingEventsDetailsVO = new ExcitingEventsDetailsVO();
        RearExcitingEvents rearExcitingEvents = this.rearExcitingEventsMapper.selectRearExcitingEventsById(Id);
        BeanUtils.copyProperties((Object)rearExcitingEvents, (Object)excitingEventsDetailsVO);
        excitingEventsDetailsVO.setRedDotPromptMark(Boolean.valueOf(EventsOperateStateEnums.getDescByType((String)rearExcitingEvents.getRedDotPrompt())));
        excitingEventsDetailsVO.setAutomaticEjectMark(Boolean.valueOf(EventsOperateStateEnums.getDescByType((String)rearExcitingEvents.getAutomaticEject())));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ArrayList<String> launchTime = new ArrayList<String>();
        launchTime.add(sdf.format(rearExcitingEvents.getLaunchStartTime()));
        launchTime.add(sdf.format(rearExcitingEvents.getLaunchFinishTime()));
        excitingEventsDetailsVO.setLaunchTime(launchTime);
        if (!StringUtils.isEmpty((String)rearExcitingEvents.getEventsPictureUrl())) {
            JSONArray list = JSON.parseArray((String)rearExcitingEvents.getEventsPictureUrl());
            ArrayList<Map> eventsPictureUrl = new ArrayList<Map>();
            for (Object object : list) {
                Map ret = (Map)object;
                eventsPictureUrl.add(ret);
            }
            excitingEventsDetailsVO.setEventsPictureUrl(eventsPictureUrl);
        }
        return excitingEventsDetailsVO;
    }

    public List<RearExcitingEvents> selectRearExcitingEventsList(RearExcitingEventsListPO rearExcitingEventsListPO) {
        if (rearExcitingEventsListPO.getCreateTimeList() != null && rearExcitingEventsListPO.getCreateTimeList().size() > 0) {
            rearExcitingEventsListPO.setCreateStartTime((String)rearExcitingEventsListPO.getCreateTimeList().get(0));
            rearExcitingEventsListPO.setCreateFinishTime((String)rearExcitingEventsListPO.getCreateTimeList().get(1));
        }
        return this.rearExcitingEventsMapper.selectRearExcitingEventsList(rearExcitingEventsListPO);
    }

    public InterfaceCallVO insertRearExcitingEvents(RearExcitingEventsAddPO rearExcitingEventsAddPO) {
        InterfaceCallVO interfaceCallVO = new InterfaceCallVO();
        Date newDate = new Date();
        String combination = SecurityUtils.getUsername() + newDate;
        String md5Key = DigestUtils.md5DigestAsHex((byte[])combination.getBytes(StandardCharsets.UTF_8));
        rearExcitingEventsAddPO.setEventsId(md5Key);
        RearExcitingEvents rearExcitingEvents = new RearExcitingEvents();
        BeanUtils.copyProperties((Object)rearExcitingEventsAddPO, (Object)rearExcitingEvents);
        rearExcitingEvents.setEventsState(EventsStateEnums.PLACED.getValue());
        rearExcitingEvents.setCreateTime(DateUtils.getNowDate());
        rearExcitingEvents.setCreateBy(SecurityUtils.getUsername());
        rearExcitingEvents.setEventsId(md5Key);
        rearExcitingEvents.setEventsPictureUrl(JSON.toJSONString((Object)rearExcitingEventsAddPO.getPictureList()));
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            rearExcitingEvents.setLaunchStartTime(sdf.parse((String)rearExcitingEventsAddPO.getLaunchTime().get(0)));
            rearExcitingEvents.setLaunchFinishTime(sdf.parse((String)rearExcitingEventsAddPO.getLaunchTime().get(1)));
        }
        catch (ParseException e) {
            System.out.println("\u65e5\u671f\u683c\u5f0f\u89e3\u6790\u9519\u8bef");
            e.printStackTrace();
        }
        RearExcitingEventsForeignPO rearExcitingEventsForeignPO = new RearExcitingEventsForeignPO();
        BeanUtils.copyProperties((Object)rearExcitingEventsAddPO, (Object)rearExcitingEventsForeignPO);
        InterfaceHandlePO interfaceHandlePO = this.foreignInterface(rearExcitingEventsForeignPO, OperateMarkEnums.INSERT.getValue());
        if (interfaceHandlePO.getErrorNumber() == 0) {
            log.info("\u65b0\u589e\u7cbe\u5f69\u4e8b\u4ef6\u6210\u529f: \u6d88\u606fid={}", (Object)md5Key);
            interfaceCallVO = this.interfaceSendUtils.interfaceCall(interfaceHandlePO.getServerNumber(), interfaceHandlePO.getErrorNumber(), interfaceHandlePO.getInterfaceSendVOList());
            this.rearExcitingEventsMapper.insertRearExcitingEvents(rearExcitingEvents);
        } else if (interfaceHandlePO.getErrorNumber() != 0 && interfaceHandlePO.getErrorNumber() < interfaceHandlePO.getServerNumber()) {
            log.info("\u65b0\u589e\u7cbe\u5f69\u4e8b\u4ef6\u90e8\u5206\u6210\u529f: \u6d88\u606fid={},\u5931\u8d25\u6570\u91cf={},\u5931\u8d25\u670d\u52a1\u5668={}", new Object[]{md5Key, interfaceHandlePO.getErrorNumber(), interfaceHandlePO.getErrorList()});
            Integer successNumber = interfaceHandlePO.getServerNumber() - interfaceHandlePO.getErrorNumber();
            interfaceCallVO = this.interfaceSendUtils.interfaceCall(successNumber, interfaceHandlePO.getErrorNumber(), interfaceHandlePO.getInterfaceSendVOList());
            rearExcitingEvents.setDistrictServer(interfaceHandlePO.getSuccessStrand());
            this.rearExcitingEventsMapper.insertRearExcitingEvents(rearExcitingEvents);
        } else {
            log.info("\u65b0\u589e\u7cbe\u5f69\u4e8b\u4ef6\u5931\u8d25: \u6d88\u606fid={}", (Object)md5Key);
            interfaceCallVO = this.interfaceSendUtils.interfaceCall(Integer.valueOf(0), interfaceHandlePO.getErrorNumber(), interfaceHandlePO.getInterfaceSendVOList());
        }
        return interfaceCallVO;
    }

    public InterfaceHandlePO foreignInterface(RearExcitingEventsForeignPO rearExcitingEventsForeignPO, String operateMark) {
        List rearServerConfigList = this.interfaceSendUtils.serverSlicing(rearExcitingEventsForeignPO.getDistrictServer());
        InterfaceSendPO interfaceSendPO = this.foreignInterfaceValueHandle(rearExcitingEventsForeignPO, operateMark);
        String successMark = "";
        Integer errorNumber = 0;
        ArrayList<String> errorList = new ArrayList<String>();
        ArrayList<InterfaceSendVO> interfaceSendVOList = new ArrayList<InterfaceSendVO>();
        for (RearServerConfig rearServerConfig : rearServerConfigList) {
            interfaceSendPO.getSuppliedMap().put("serverId", rearServerConfig.getServerId());
            interfaceSendPO.getPrintMap().put("serverId", rearServerConfig.getServerId());
            String visitUrl = "http://" + rearServerConfig.getServerIp() + ":" + rearServerConfig.getServerPort() + "/\u7cbe\u5f69\u4e8b\u4ef6\u63a5\u53e3";
            interfaceSendPO.setVisitUrl(visitUrl);
            InterfaceSendVO interfaceSendVO = this.interfaceSendUtils.interfaceSend(interfaceSendPO);
            interfaceSendVO.setServerId(rearServerConfig.getServerId());
            if (interfaceSendVO.getState().booleanValue()) {
                successMark = successMark + "," + interfaceSendVO.getServerId();
            } else {
                errorNumber = errorNumber + 1;
                errorList.add(rearServerConfig.getServerId());
            }
            interfaceSendVOList.add(interfaceSendVO);
        }
        InterfaceHandlePO interfaceHandlePO = new InterfaceHandlePO();
        interfaceHandlePO.setErrorNumber(errorNumber);
        interfaceHandlePO.setSuccessStrand(successMark);
        interfaceHandlePO.setServerNumber(Integer.valueOf(rearServerConfigList.size()));
        interfaceHandlePO.setInterfaceSendVOList(interfaceSendVOList);
        interfaceHandlePO.setErrorList(errorList);
        return interfaceHandlePO;
    }

    public InterfaceSendPO foreignInterfaceValueHandle(RearExcitingEventsForeignPO rearExcitingEventsForeignPO, String operateMark) {
        InterfaceSendPO interfaceSendPO = new InterfaceSendPO();
        interfaceSendPO.setInterfaceDescribe("\u7cbe\u5f69\u4e8b\u4ef6");
        Map pidGidMap = this.interfaceSendUtils.pidGidIntercept(rearExcitingEventsForeignPO.getChannelGame());
        ArrayList pictureNewList = new ArrayList();
        List pictureList = rearExcitingEventsForeignPO.getPictureList();
        if (pictureList != null && pictureList.size() > 0) {
            for (int i = 0; i < pictureList.size(); ++i) {
                Map pictureMap = (Map)pictureList.get(i);
                pictureNewList.add(pictureMap.get("url"));
            }
        }
        HashMap<String, Object> suppliedMap = new HashMap<String, Object>();
        suppliedMap.put("eventsId", rearExcitingEventsForeignPO.getEventsId());
        suppliedMap.put("pictureList", pictureNewList);
        suppliedMap.put("jumpUrl", rearExcitingEventsForeignPO.getJumpUrl());
        suppliedMap.put("registerTime", rearExcitingEventsForeignPO.getRegisterTime());
        suppliedMap.put("channelGame", pidGidMap);
        suppliedMap.put("redDotPrompt", rearExcitingEventsForeignPO.getRedDotPrompt());
        suppliedMap.put("automaticEject", rearExcitingEventsForeignPO.getAutomaticEject());
        if (rearExcitingEventsForeignPO.getLaunchTime() != null && rearExcitingEventsForeignPO.getLaunchTime().size() > 0) {
            suppliedMap.put("launchStartTime", rearExcitingEventsForeignPO.getLaunchTime().get(0));
            suppliedMap.put("launchFinishTime", rearExcitingEventsForeignPO.getLaunchTime().get(1));
        }
        interfaceSendPO.setSuppliedMap(suppliedMap);
        HashMap<String, Object> printMap = new HashMap<String, Object>();
        printMap.put("eventsId", rearExcitingEventsForeignPO.getEventsId());
        printMap.put("operateMark", Integer.valueOf(operateMark));
        interfaceSendPO.setPrintMap(printMap);
        return interfaceSendPO;
    }

    public int updateRearExcitingEvents(RearExcitingEvents rearExcitingEvents) {
        rearExcitingEvents.setUpdateTime(DateUtils.getNowDate());
        return this.rearExcitingEventsMapper.updateRearExcitingEvents(rearExcitingEvents);
    }

    public int deleteRearExcitingEventsByIds(Long[] Ids) {
        return this.rearExcitingEventsMapper.deleteRearExcitingEventsByIds(Ids);
    }

    public int deleteRearExcitingEventsById(Long Id) {
        return this.rearExcitingEventsMapper.deleteRearExcitingEventsById(Id);
    }

    public InterfaceCallVO upDownShelves(Long id, String eventsState) {
        InterfaceCallVO interfaceCallVO = new InterfaceCallVO();
        String eventsStateName = EventsStateEnums.getDescByValue((String)eventsState) + "\u7cbe\u5f69\u4e8b\u4ef6";
        RearExcitingEvents rearExcitingEventsDetails = this.rearExcitingEventsMapper.selectRearExcitingEventsById(id);
        RearExcitingEvents rearExcitingEventsUpdate = new RearExcitingEvents();
        rearExcitingEventsUpdate.setId(id);
        rearExcitingEventsUpdate.setUpdateTime(DateUtils.getNowDate());
        rearExcitingEventsUpdate.setUpdateBy(SecurityUtils.getUsername());
        RearExcitingEventsForeignPO rearExcitingEventsForeignPO = new RearExcitingEventsForeignPO();
        BeanUtils.copyProperties((Object)rearExcitingEventsDetails, (Object)rearExcitingEventsForeignPO);
        String operateMark = "";
        operateMark = eventsState.equals(EventsStateEnums.PLACED.getValue()) ? OperateMarkEnums.GROUNDING.getValue() : OperateMarkEnums.OFF_SHELF.getValue();
        InterfaceHandlePO interfaceHandlePO = this.foreignInterface(rearExcitingEventsForeignPO, operateMark);
        if (interfaceHandlePO.getErrorNumber() == 0) {
            log.info(eventsStateName + "\u6210\u529f: \u6d88\u606fid={}", (Object)rearExcitingEventsDetails.getEventsId());
            interfaceCallVO = this.interfaceSendUtils.interfaceCall(interfaceHandlePO.getServerNumber(), interfaceHandlePO.getErrorNumber(), interfaceHandlePO.getInterfaceSendVOList());
            rearExcitingEventsUpdate.setEventsState(eventsState);
            this.rearExcitingEventsMapper.updateRearExcitingEvents(rearExcitingEventsUpdate);
        } else if (interfaceHandlePO.getErrorNumber() != 0 && interfaceHandlePO.getErrorNumber() < interfaceHandlePO.getServerNumber()) {
            log.info(eventsStateName + "\u90e8\u5206\u6210\u529f: \u6d88\u606fid={},\u5931\u8d25\u6570\u91cf={},\u5931\u8d25\u670d\u52a1\u5668={}", new Object[]{rearExcitingEventsDetails.getEventsId(), interfaceHandlePO.getErrorNumber(), interfaceHandlePO.getErrorList()});
            Integer successNumber = interfaceHandlePO.getServerNumber() - interfaceHandlePO.getErrorNumber();
            interfaceCallVO = this.interfaceSendUtils.interfaceCall(successNumber, interfaceHandlePO.getErrorNumber(), interfaceHandlePO.getInterfaceSendVOList());
            rearExcitingEventsUpdate.setDistrictServer(interfaceHandlePO.getSuccessStrand());
            this.rearExcitingEventsMapper.updateRearExcitingEvents(rearExcitingEventsUpdate);
        } else {
            log.info(eventsStateName + "\u5931\u8d25: \u6d88\u606fid={}", (Object)rearExcitingEventsDetails.getEventsId());
            interfaceCallVO = this.interfaceSendUtils.interfaceCall(Integer.valueOf(0), interfaceHandlePO.getErrorNumber(), interfaceHandlePO.getInterfaceSendVOList());
        }
        return interfaceCallVO;
    }
}

