/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.service.impl.operate.activity;

import com.ruoyi.common.core.utils.StringUtils;
import com.ruoyi.common.core.web.page.TableDataInfo;
import com.ruoyi.rearend.domain.RearServerConfig;
import com.ruoyi.rearend.domain.po.operate.activity.GameActivity;
import com.ruoyi.rearend.domain.po.operate.activity.GameActivityPO;
import com.ruoyi.rearend.domain.vo.operate.activity.GameActivityApiVO;
import com.ruoyi.rearend.domain.vo.operate.activity.GameActivityVO;
import com.ruoyi.rearend.enums.BaseSuccessFailEnums;
import com.ruoyi.rearend.enums.operate.ActivityProgressEnums;
import com.ruoyi.rearend.enums.operate.ActivityTimeEnums;
import com.ruoyi.rearend.service.impl.server.RearServerServiceImpl;
import com.ruoyi.rearend.service.operate.activity.IGameActivityService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class GameActivityServiceImpl
implements IGameActivityService {
    @Autowired
    private RearServerServiceImpl rearServerServiceImpl;
    private static final Logger log = LoggerFactory.getLogger(GameActivityServiceImpl.class);

    public TableDataInfo selectGameActivityList(GameActivityPO gameActivityPO) {
        TableDataInfo tableDataInfo = new TableDataInfo();
        GameActivityApiVO gameActivityApiVO = new GameActivityApiVO();
        List gameActivityVOList = new ArrayList();
        gameActivityPO.setPage(gameActivityPO.getPageNum());
        gameActivityPO.setShowNum(gameActivityPO.getPageSize());
        Integer serviceId = gameActivityPO.getServiceId();
        RearServerConfig RearServerConfig2 = this.rearServerServiceImpl.serverIdQuery(String.valueOf(serviceId));
        if (RearServerConfig2 == null || StringUtils.isEmpty((String)RearServerConfig2.getServerIp())) {
            log.error("\u67e5\u8be2\u6d3b\u52a8\u5931\u8d25\u6b64\u670d\u52a1\u5668\u65e0ip\u4e0a\u62a5\u4fe1\u606f: \u5165\u53c2={}", (Object)gameActivityPO);
            return tableDataInfo;
        }
        String serverIp = RearServerConfig2.getServerIp();
        Integer serverPort = RearServerConfig2.getServerPort();
        String visitUrl = "http://" + serverIp + ":" + serverPort + "/queryActivityInfos";
        try {
            log.info("\u8c03\u7528\u67e5\u8be2\u6d3b\u52a8\u63a5\u53e3: \u5165\u53c2={}", (Object)gameActivityPO);
            RestTemplate restTemplate = new RestTemplate();
            HttpHeaders headers = new HttpHeaders();
            MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
            headers.setContentType(type);
            headers.add("Accept", MediaType.APPLICATION_JSON.toString());
            HttpEntity formEntity = new HttpEntity((Object)gameActivityPO, (MultiValueMap)headers);
            gameActivityApiVO = (GameActivityApiVO)restTemplate.postForObject(visitUrl, (Object)formEntity, GameActivityApiVO.class, new Object[0]);
            log.info("\u8c03\u7528\u67e5\u8be2\u6d3b\u52a8\u63a5\u53e3\u63a5\u53e3\u8fd4\u56de: \u51fa\u53c2code={},\u51fa\u53c2msg={}", (Object)gameActivityApiVO.getCode(), (Object)gameActivityApiVO.getMessage());
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u670d\u52a1\u7aef\u67e5\u8be2\u6d3b\u52a8\u63a5\u53e3\u5f02\u5e38: \u5165\u53c2={}", (Object)gameActivityPO);
            return tableDataInfo;
        }
        if (gameActivityApiVO == null || gameActivityApiVO.getCode() != BaseSuccessFailEnums.SUCCESS.getValue() || gameActivityApiVO.getData() == null) {
            log.error("\u67e5\u8be2\u6d3b\u52a8\u5931\u8d25: \u5165\u53c2={},\u51fa\u53c2={}", (Object)gameActivityPO, (Object)gameActivityApiVO);
            return tableDataInfo;
        }
        gameActivityVOList = gameActivityApiVO.getData().getQueryActivityInfos();
        this.activityVOHandle(gameActivityVOList);
        tableDataInfo.setRows(gameActivityVOList);
        tableDataInfo.setTotal((long)gameActivityApiVO.getData().getTotalNum().intValue());
        return tableDataInfo;
    }

    public void activityVOHandle(List<GameActivityVO> gameActivityVOList) {
        if (gameActivityVOList == null || gameActivityVOList.size() <= 0) {
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (GameActivityVO gameActivityVO : gameActivityVOList) {
            if (gameActivityVO.getStartTime() != ActivityTimeEnums.PERMANENTLY_OPEN.getValue() && gameActivityVO.getStartTime() != ActivityTimeEnums.PERMANENTLY_CLOSE.getValue() && gameActivityVO.getStartTime() != ActivityTimeEnums.NOT_TURNED_ON.getValue()) {
                gameActivityVO.setStartTimeShow(sdf.format(gameActivityVO.getStartTime()));
            } else {
                gameActivityVO.setStartTimeShow(ActivityTimeEnums.getDescByValue((Long)gameActivityVO.getStartTime()));
            }
            if (gameActivityVO.getEndTime() != ActivityTimeEnums.PERMANENTLY_OPEN.getValue() && gameActivityVO.getEndTime() != ActivityTimeEnums.PERMANENTLY_CLOSE.getValue() && gameActivityVO.getEndTime() != ActivityTimeEnums.NOT_TURNED_ON.getValue()) {
                gameActivityVO.setEndTimeShow(sdf.format(gameActivityVO.getEndTime()));
            } else {
                gameActivityVO.setEndTimeShow(ActivityTimeEnums.getDescByValue((Long)gameActivityVO.getEndTime()));
            }
            if (StringUtils.isEmpty((String)gameActivityVO.getProgress())) continue;
            gameActivityVO.setProgressShow(ActivityProgressEnums.getDescByType((String)gameActivityVO.getProgress()));
        }
    }

    public GameActivity selectGameActivityById(Long Id) {
        return null;
    }
}

