/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.service.impl.game.recharge;

import com.ruoyi.common.core.exception.CustomServiceException;
import com.ruoyi.common.core.exception.ServiceException;
import com.ruoyi.rearend.api.RearEndServerRechargeApi;
import com.ruoyi.rearend.domain.GameRechargeOrderLog;
import com.ruoyi.rearend.domain.po.game.recharge.RechargePO;
import com.ruoyi.rearend.domain.vo.game.recharge.GameRechargeOrderVO;
import com.ruoyi.rearend.domain.vo.game.recharge.RechargeVO;
import com.ruoyi.rearend.domain.vo.game.recharge.ServerConfigVO;
import com.ruoyi.rearend.enums.BaseYesNoEnums;
import com.ruoyi.rearend.enums.game.CallTypeEnums;
import com.ruoyi.rearend.enums.game.SendOutGoodsRequestEnums;
import com.ruoyi.rearend.mapper.game.recharge.GameRechargeOrderMapper;
import com.ruoyi.rearend.service.impl.game.recharge.GameRechargeOrderLogServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GameRechargeServiceImpl {
    @Autowired
    private GameRechargeOrderLogServiceImpl gameRechargeOrderLogServiceImpl;
    @Autowired
    private GameRechargeOrderMapper gameRechargeOrderMapper;
    @Autowired
    private RearEndServerRechargeApi rearEndServerRechargeApi;
    private static final Logger log = LoggerFactory.getLogger(GameRechargeServiceImpl.class);

    public RechargeVO sendOutGoodsMethod(GameRechargeOrderLog gameRechargeOrderLog, GameRechargeOrderVO gameRechargeOrderVO) {
        RechargeVO rechargeVO = new RechargeVO();
        RechargePO rechargePO = this.RechargePOHandle(gameRechargeOrderLog, gameRechargeOrderVO);
        try {
            log.info("\u9875\u9762\u7533\u8bf7\u8865\u5355: \u5165\u53c2={}", (Object)rechargePO);
            rechargeVO = this.rearEndServerRechargeApi.rechargeAdd(rechargePO);
            log.info("\u9875\u9762\u7533\u8bf7\u8865\u5355: \u51fa\u53c2={}", (Object)rechargeVO);
            if (rechargeVO == null || rechargeVO.getCode() == null || !rechargeVO.getCode().equals(SendOutGoodsRequestEnums.SUCCESS.getValue())) {
                gameRechargeOrderLog.setOrderState(rechargeVO.getCode());
                gameRechargeOrderLog.setOrderStateDescribe(rechargeVO.getMsg());
                throw new ServiceException("\u8865\u5355\u5931\u8d25");
            }
            gameRechargeOrderLog.setOrderState(SendOutGoodsRequestEnums.SUCCESS.getValue());
            gameRechargeOrderLog.setOrderStateDescribe(SendOutGoodsRequestEnums.SUCCESS.getDesc());
            this.insertSendOutGoodsLog(gameRechargeOrderLog, gameRechargeOrderVO);
        }
        catch (Exception e) {
            if (rechargeVO != null) {
                this.exceptionPromptCustom(rechargeVO.getCode(), "\u8865\u5355\u5931\u8d25: " + rechargeVO.getMsg(), gameRechargeOrderLog, gameRechargeOrderVO);
            }
            this.exceptionPrompt(SendOutGoodsRequestEnums.ERROR.getValue(), gameRechargeOrderLog, gameRechargeOrderVO);
        }
        return rechargeVO;
    }

    public RechargePO RechargePOHandle(GameRechargeOrderLog gameRechargeOrderLog, GameRechargeOrderVO gameRechargeOrderVO) {
        RechargePO rechargePO = new RechargePO();
        rechargePO.setServerId(gameRechargeOrderVO.getSid().toString());
        rechargePO.setOrderId(gameRechargeOrderVO.getOrderId());
        rechargePO.setOrderNo(gameRechargeOrderVO.getOrderNo());
        rechargePO.setPlayerId(Long.valueOf(gameRechargeOrderVO.getActorId()).longValue());
        rechargePO.setExt(gameRechargeOrderVO.getExt());
        rechargePO.setForce(BaseYesNoEnums.YES.getValue());
        Integer money = (int)(gameRechargeOrderVO.getMoney().floatValue() * 100.0f);
        rechargePO.setMoney(money);
        ServerConfigVO serverConfigVO = this.gameRechargeOrderMapper.queryServerConfig(gameRechargeOrderVO.getSid());
        if (serverConfigVO == null) {
            this.exceptionPrompt(SendOutGoodsRequestEnums.SERVER_ABSENT.getValue(), gameRechargeOrderLog, gameRechargeOrderVO);
        }
        rechargePO.setServerIp(serverConfigVO.getServerIp());
        rechargePO.setServerPort(serverConfigVO.getServerPort());
        rechargePO.setTime(Long.valueOf(gameRechargeOrderVO.getTime()).longValue());
        return rechargePO;
    }

    public void exceptionPrompt(String SendOutGoodsCode, GameRechargeOrderLog gameRechargeOrderLog, GameRechargeOrderVO gameRechargeOrderVO) {
        String desc = SendOutGoodsRequestEnums.getDescByValue((String)SendOutGoodsCode);
        gameRechargeOrderLog.setOrderState(SendOutGoodsCode);
        gameRechargeOrderLog.setOrderStateDescribe(desc);
        this.insertSendOutGoodsLog(gameRechargeOrderLog, gameRechargeOrderVO);
        throw new CustomServiceException(desc, SendOutGoodsCode);
    }

    public void exceptionPromptCustom(String code, String msg, GameRechargeOrderLog gameRechargeOrderLog, GameRechargeOrderVO gameRechargeOrderVO) {
        gameRechargeOrderLog.setOrderState(code);
        gameRechargeOrderLog.setOrderStateDescribe(msg);
        this.insertSendOutGoodsLog(gameRechargeOrderLog, gameRechargeOrderVO);
        throw new CustomServiceException(msg, code);
    }

    public void insertSendOutGoodsLog(GameRechargeOrderLog gameRechargeOrderLog, GameRechargeOrderVO gameRechargeOrderVO) {
        BeanUtils.copyProperties((Object)gameRechargeOrderVO, (Object)gameRechargeOrderLog);
        gameRechargeOrderLog.setCallType(CallTypeEnums.MANUAL.getValue());
        this.gameRechargeOrderLogServiceImpl.insertGameRechargeOrderLog(gameRechargeOrderLog);
    }
}

