/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.service.impl.game.internalplayer;

import com.ruoyi.common.core.utils.DateUtils;
import com.ruoyi.rearend.domain.InternalPlayer;
import com.ruoyi.rearend.domain.po.InterfaceSendPO;
import com.ruoyi.rearend.domain.po.game.internalplayer.InternalPlayerAddPO;
import com.ruoyi.rearend.domain.po.player.BatchPlayerQueryPO;
import com.ruoyi.rearend.domain.vo.InterfaceSendVO;
import com.ruoyi.rearend.domain.vo.player.BatchPlayerQueryVO;
import com.ruoyi.rearend.enums.game.InsertInternalPlayerAddTypeEnums;
import com.ruoyi.rearend.enums.palyer.SendingTypeEnums;
import com.ruoyi.rearend.mapper.game.internalplayer.InternalPlayerMapper;
import com.ruoyi.rearend.service.game.internalplayer.IInternalPlayerService;
import com.ruoyi.rearend.service.player.IRearPlayerService;
import com.ruoyi.rearend.utils.InterfaceSendUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InternalPlayerServiceImpl
implements IInternalPlayerService {
    @Autowired
    private InternalPlayerMapper internalPlayerMapper;
    @Autowired
    private InterfaceSendUtils interfaceSendUtils;
    @Autowired
    private IRearPlayerService iRearPlayerService;

    public InternalPlayer selectInternalPlayerById(Long Id) {
        return this.internalPlayerMapper.selectInternalPlayerById(Id);
    }

    public List<InternalPlayer> selectInternalPlayerList(InternalPlayer internalPlayer) {
        return this.internalPlayerMapper.selectInternalPlayerList(internalPlayer);
    }

    @Transactional(rollbackFor={Exception.class})
    public String insertInternalPlayer(InternalPlayerAddPO internalPlayerAddPO) {
        String state = null;
        if (InsertInternalPlayerAddTypeEnums.SINGLE.getValue() == internalPlayerAddPO.getAddType()) {
            InternalPlayer internalPlayer = new InternalPlayer();
            BeanUtils.copyProperties((Object)internalPlayerAddPO, (Object)internalPlayer);
            state = this.insertInternalPlayerSingleAdd(internalPlayer);
            return state;
        }
        ArrayList<InternalPlayer> internalPlayerList = new ArrayList<InternalPlayer>();
        List<String> serverList = Arrays.asList(internalPlayerAddPO.getAddDataJson().split("\n"));
        for (int i = 0; i < serverList.size(); ++i) {
            List<Object> userList = new ArrayList();
            userList = Arrays.asList(serverList.get(i).split(","));
            InternalPlayer internalPlayer = new InternalPlayer();
            internalPlayer.setServerId((String)userList.get(0));
            internalPlayer.setUserPlayerType((String)userList.get(1));
            internalPlayer.setUserName((String)userList.get(2));
            int index = ((String)userList.get(3)).indexOf("|");
            String result = ((String)userList.get(3)).substring(0, index);
            System.out.println(result);
            String tail = ((String)userList.get(3)).substring(index + 1);
            internalPlayer.setUserAccount(result);
            internalPlayer.setUserPlayerId(tail);
            internalPlayerList.add(internalPlayer);
        }
        for (InternalPlayer internalPlayer : internalPlayerList) {
            String prompt = this.insertInternalPlayerSingleAdd(internalPlayer);
            state = state + prompt + "\n";
        }
        return state;
    }

    public String insertInternalPlayerSingleAdd(InternalPlayer internalPlayer) {
        internalPlayer.setCreateTime(DateUtils.getNowDate());
        int mark = this.internalPlayerMapper.insertInternalPlayer(internalPlayer);
        String addState = "\u65b0\u589e\u6210\u529f";
        String visitUrl = this.interfaceSendUtils.serverUrlAddress(internalPlayer.getServerId(), "identifyPlayer");
        List<String> playerIds = Arrays.asList(internalPlayer.getUserPlayerId().split(","));
        InterfaceSendPO interfaceSendPO = new InterfaceSendPO();
        interfaceSendPO.setVisitUrl(visitUrl);
        interfaceSendPO.setInterfaceDescribe("\u5185\u90e8\u73a9\u5bb6\u4fee\u6539");
        HashMap<String, Object> suppliedMap = new HashMap<String, Object>();
        suppliedMap.put("serviceId", internalPlayer.getServerId());
        suppliedMap.put("playerIds", playerIds);
        suppliedMap.put("identification", internalPlayer.getUserPlayerType());
        interfaceSendPO.setSuppliedMap(suppliedMap);
        HashMap<String, Object> printMap = new HashMap<String, Object>();
        printMap.put("serviceId", internalPlayer.getServerId());
        printMap.put("playerIds", playerIds);
        printMap.put("identification", internalPlayer.getUserPlayerType());
        interfaceSendPO.setPrintMap(printMap);
        InterfaceSendVO interfaceSendVO = this.interfaceSendUtils.interfaceSend(interfaceSendPO);
        Map dataMap = (Map)interfaceSendVO.getData();
        List failPlayerIds = (List)dataMap.get("failPlayerIds");
        if (failPlayerIds != null && failPlayerIds.size() > 0) {
            addState = "\u6b64\u6570\u636e\u5b58\u5728\u5931\u8d25\u6570\u636e" + failPlayerIds + ",\u5efa\u8bae\u624b\u52a8\u4fee\u6539\u5c06\u9519\u8bef\u6570\u636e\u5220\u9664";
        }
        return addState;
    }

    @Transactional(rollbackFor={Exception.class})
    public String updateInternalPlayer(InternalPlayer internalPlayer) {
        internalPlayer.setUpdateTime(DateUtils.getNowDate());
        this.internalPlayerMapper.updateInternalPlayer(internalPlayer);
        String updateState = "\u4fee\u6539\u6210\u529f";
        String visitUrl = this.interfaceSendUtils.serverUrlAddress(internalPlayer.getServerId(), "identifyPlayer");
        List<String> playerIds = Arrays.asList(internalPlayer.getUserPlayerId().split(","));
        InterfaceSendPO interfaceSendPO = new InterfaceSendPO();
        interfaceSendPO.setVisitUrl(visitUrl);
        interfaceSendPO.setInterfaceDescribe("\u5185\u90e8\u73a9\u5bb6\u4fee\u6539");
        HashMap<String, Object> suppliedMap = new HashMap<String, Object>();
        suppliedMap.put("serviceId", internalPlayer.getServerId());
        suppliedMap.put("playerIds", playerIds);
        suppliedMap.put("identification", internalPlayer.getUserPlayerType());
        interfaceSendPO.setSuppliedMap(suppliedMap);
        HashMap<String, Object> printMap = new HashMap<String, Object>();
        printMap.put("serviceId", internalPlayer.getServerId());
        printMap.put("playerIds", playerIds);
        printMap.put("identification", internalPlayer.getUserPlayerType());
        interfaceSendPO.setPrintMap(printMap);
        InterfaceSendVO interfaceSendVO = this.interfaceSendUtils.interfaceSend(interfaceSendPO);
        Map dataMap = (Map)interfaceSendVO.getData();
        List failPlayerIds = (List)dataMap.get("failPlayerIds");
        if (failPlayerIds != null && failPlayerIds.size() > 0) {
            updateState = "\u6b64\u6570\u636e\u5b58\u5728\u5931\u8d25\u6570\u636e" + failPlayerIds + ",\u5efa\u8bae\u624b\u52a8\u4fee\u6539\u5c06\u9519\u8bef\u6570\u636e\u5220\u9664";
        }
        return updateState;
    }

    public List<String> queryInternalPlayerIdList() {
        return this.internalPlayerMapper.queryInternalPlayerIdList();
    }

    public List<String> queryInternalAccountList() {
        return this.internalPlayerMapper.queryInternalAccountList();
    }

    public InternalPlayer internalPlayerDetails(String userPlayerId) {
        return this.internalPlayerMapper.internalPlayerDetails(userPlayerId);
    }

    public BatchPlayerQueryVO batchAddDetection(InternalPlayerAddPO internalPlayerAddPO) {
        String userPlayerId = "";
        ArrayList<InternalPlayer> internalPlayerList = new ArrayList<InternalPlayer>();
        List<String> serverList = Arrays.asList(internalPlayerAddPO.getAddDataJson().split("\n"));
        for (int i = 0; i < serverList.size(); ++i) {
            List<Object> userList = new ArrayList();
            userList = Arrays.asList(serverList.get(i).split(","));
            InternalPlayer internalPlayer = new InternalPlayer();
            internalPlayer.setServerId((String)userList.get(0));
            internalPlayer.setUserPlayerType((String)userList.get(1));
            internalPlayer.setUserName((String)userList.get(2));
            int index = ((String)userList.get(3)).indexOf("|");
            String result = ((String)userList.get(3)).substring(0, index);
            String tail = ((String)userList.get(3)).substring(index + 1);
            internalPlayer.setUserAccount(result);
            internalPlayer.setUserPlayerId(tail);
            internalPlayerList.add(internalPlayer);
            userPlayerId = userPlayerId + (String)userList.get(0) + "," + tail + "|*\n";
        }
        System.out.println("userPlayerId=====" + userPlayerId);
        BatchPlayerQueryPO batchPlayerQueryPO = new BatchPlayerQueryPO();
        batchPlayerQueryPO.setUserPlayerId(userPlayerId);
        batchPlayerQueryPO.setMailSendingType(SendingTypeEnums.USER_PLAYER_ID.getValue());
        BatchPlayerQueryVO batchPlayerQueryVO = this.iRearPlayerService.manyServerBatchPlayer(batchPlayerQueryPO);
        return batchPlayerQueryVO;
    }
}

