/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.service.impl.game.exchange;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ruoyi.common.core.exception.ServiceException;
import com.ruoyi.common.core.utils.DateUtils;
import com.ruoyi.common.security.utils.SecurityUtils;
import com.ruoyi.rearend.domain.RearExchange;
import com.ruoyi.rearend.domain.RearExchangeMiddle;
import com.ruoyi.rearend.domain.po.game.exchange.BatchRedemptionCodePO;
import com.ruoyi.rearend.domain.po.game.exchange.ExchangeBatchPO;
import com.ruoyi.rearend.domain.po.game.exchange.ExchangeInsertPO;
import com.ruoyi.rearend.domain.po.game.exchange.ExchangeListPO;
import com.ruoyi.rearend.domain.po.game.exchange.ExchangeMiddleInsertPO;
import com.ruoyi.rearend.domain.po.game.exchange.ExchangeUpdatePO;
import com.ruoyi.rearend.domain.vo.game.exchange.ApplyConditionVO;
import com.ruoyi.rearend.domain.vo.game.exchange.ExchangeBatchVO;
import com.ruoyi.rearend.domain.vo.game.exchange.ExchangeDetailsVO;
import com.ruoyi.rearend.domain.vo.game.exchange.ExchangeListVO;
import com.ruoyi.rearend.domain.vo.game.exchange.ExchangeNumberOfUsesVO;
import com.ruoyi.rearend.enums.game.ExchangeApplyConditionEnums;
import com.ruoyi.rearend.enums.game.ExchangeDescribeEnums;
import com.ruoyi.rearend.enums.game.ExchangeStateEnums;
import com.ruoyi.rearend.mapper.game.exchange.RearExchangeMapper;
import com.ruoyi.rearend.service.game.exchange.IRearExchangeService;
import com.ruoyi.rearend.service.impl.game.exchange.GameExchangeUseLogServiceImpl;
import com.ruoyi.rearend.service.impl.game.exchange.RearExchangeMiddleServiceImpl;
import com.ruoyi.rearend.utils.RandomCodeUtils;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.DigestUtils;

@Service
public class RearExchangeServiceImpl
implements IRearExchangeService {
    @Autowired
    private RearExchangeMapper rearExchangeMapper;
    @Autowired
    private RearExchangeMiddleServiceImpl rearExchangeMiddleServiceImpl;
    @Autowired
    private GameExchangeUseLogServiceImpl gameExchangeUseLogServiceImpl;

    public ExchangeDetailsVO selectRearExchangeById(Long Id) {
        ExchangeDetailsVO exchangeDetailsVO = new ExchangeDetailsVO();
        RearExchange rearExchange = this.rearExchangeMapper.selectRearExchangeById(Id);
        BeanUtils.copyProperties((Object)rearExchange, (Object)exchangeDetailsVO);
        ArrayList serverIdList = new ArrayList();
        RearExchangeMiddle rearExchangeMiddle = new RearExchangeMiddle();
        rearExchangeMiddle.setExchangeId(rearExchange.getExchangeId());
        List rearExchangeMiddleList = this.rearExchangeMiddleServiceImpl.selectRearExchangeMiddleList(rearExchangeMiddle);
        if (rearExchangeMiddleList != null && rearExchangeMiddleList.size() > 0) {
            for (RearExchangeMiddle rearExchangeMiddleFor : rearExchangeMiddleList) {
                ArrayList<String> listFor = new ArrayList<String>();
                listFor.add(rearExchangeMiddleFor.getRegionId());
                listFor.add(rearExchangeMiddleFor.getServerId());
                serverIdList.add(listFor);
            }
        }
        exchangeDetailsVO.setServerIdList(serverIdList);
        JSONArray list = JSON.parseArray((String)rearExchange.getPropJson());
        ArrayList<Map> mailPropJsonList = new ArrayList<Map>();
        for (Object object : list) {
            Map ret = (Map)object;
            mailPropJsonList.add(ret);
        }
        exchangeDetailsVO.setPropJsonList(mailPropJsonList);
        return exchangeDetailsVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public int insertRearExchange(ExchangeInsertPO exchangeInsertPO) {
        Integer exchangeNumber = this.rearExchangeMapper.queryExchangeId(exchangeInsertPO.getExchangeId());
        if (exchangeNumber != null && exchangeNumber > 0) {
            throw new ServiceException("\u6b64\u5151\u6362\u7801id\u5df2\u5b58\u5728,\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        RearExchange rearExchange = new RearExchange();
        BeanUtils.copyProperties((Object)exchangeInsertPO, (Object)rearExchange);
        rearExchange.setPropJson(JSON.toJSONString((Object)exchangeInsertPO.getPropJsonList()));
        rearExchange.setCreateTime(DateUtils.getNowDate());
        int insertState = this.rearExchangeMapper.insertRearExchange(rearExchange);
        if (exchangeInsertPO.getServerIdList() != null && exchangeInsertPO.getServerIdList().size() > 0) {
            ArrayList<ExchangeMiddleInsertPO> middleInsertPOList = new ArrayList<ExchangeMiddleInsertPO>();
            List serverIdList = exchangeInsertPO.getServerIdList();
            for (int i = 0; i < serverIdList.size(); ++i) {
                ExchangeMiddleInsertPO exchangeMiddleInsertPO = new ExchangeMiddleInsertPO();
                exchangeMiddleInsertPO.setExchangeId(exchangeInsertPO.getExchangeId());
                exchangeMiddleInsertPO.setRegionId((String)((List)serverIdList.get(i)).get(0));
                exchangeMiddleInsertPO.setServerId((String)((List)serverIdList.get(i)).get(1));
                exchangeMiddleInsertPO.setCreateBy(SecurityUtils.getUsername());
                exchangeMiddleInsertPO.setCreateTime(DateUtils.getNowDate());
                middleInsertPOList.add(exchangeMiddleInsertPO);
            }
            this.rearExchangeMiddleServiceImpl.insertBatchMiddle(middleInsertPOList);
        }
        return insertState;
    }

    @Transactional(rollbackFor={Exception.class})
    public ExchangeBatchVO exchangeBatch(ExchangeBatchPO exchangeBatchPO) {
        ExchangeBatchVO exchangeBatchVO = new ExchangeBatchVO();
        List batchExchangeIdList = this.batchExchangeId(exchangeBatchPO.getExchangeLength().intValue(), exchangeBatchPO.getExchangeNumber().intValue());
        if (batchExchangeIdList == null || batchExchangeIdList.size() == 0) {
            exchangeBatchVO.setSuccessNumber(Integer.valueOf(0));
            exchangeBatchVO.setFailNumber(exchangeBatchPO.getExchangeNumber());
            return exchangeBatchVO;
        }
        String exchangeIdString = "";
        ArrayList<BatchRedemptionCodePO> batchRedemptionCodePOList = new ArrayList<BatchRedemptionCodePO>();
        for (int i = 0; i < batchExchangeIdList.size(); ++i) {
            BatchRedemptionCodePO batchRedemptionCodePO = new BatchRedemptionCodePO();
            BeanUtils.copyProperties((Object)exchangeBatchPO, (Object)batchRedemptionCodePO);
            batchRedemptionCodePO.setExchangeId((String)batchExchangeIdList.get(i));
            batchRedemptionCodePO.setCreateBy(SecurityUtils.getUsername());
            batchRedemptionCodePO.setCreateTime(DateUtils.getNowDate());
            batchRedemptionCodePO.setPropJson(JSON.toJSONString((Object)exchangeBatchPO.getPropJsonList()));
            batchRedemptionCodePOList.add(batchRedemptionCodePO);
            this.exchangeBatchBatchMiddle(exchangeBatchPO, (String)batchExchangeIdList.get(i));
            exchangeIdString = exchangeIdString + "\n" + (String)batchExchangeIdList.get(i);
        }
        exchangeBatchVO.setExchangeIdString(exchangeIdString);
        this.rearExchangeMapper.batchRedemptionCode(batchRedemptionCodePOList);
        exchangeBatchVO.setSuccessNumber(Integer.valueOf(batchExchangeIdList.size()));
        exchangeBatchVO.setFailNumber(Integer.valueOf(exchangeBatchPO.getExchangeNumber() - batchExchangeIdList.size()));
        return exchangeBatchVO;
    }

    public void exchangeBatchBatchMiddle(ExchangeBatchPO exchangeBatchPO, String exchangeId) {
        if (exchangeBatchPO.getServerIdList() != null && exchangeBatchPO.getServerIdList().size() > 0) {
            ArrayList<ExchangeMiddleInsertPO> middleInsertPOList = new ArrayList<ExchangeMiddleInsertPO>();
            List serverIdList = exchangeBatchPO.getServerIdList();
            for (int i = 0; i < serverIdList.size(); ++i) {
                ExchangeMiddleInsertPO exchangeMiddleInsertPO = new ExchangeMiddleInsertPO();
                exchangeMiddleInsertPO.setExchangeId(exchangeId);
                exchangeMiddleInsertPO.setRegionId((String)((List)serverIdList.get(i)).get(0));
                exchangeMiddleInsertPO.setServerId((String)((List)serverIdList.get(i)).get(1));
                exchangeMiddleInsertPO.setCreateBy(SecurityUtils.getUsername());
                exchangeMiddleInsertPO.setCreateTime(DateUtils.getNowDate());
                middleInsertPOList.add(exchangeMiddleInsertPO);
            }
            this.rearExchangeMiddleServiceImpl.insertBatchMiddle(middleInsertPOList);
        }
    }

    public List<String> batchExchangeId(int stringLength, int exchangeNumber) {
        ArrayList<String> tableList = new ArrayList();
        List exchangeIdList = RandomCodeUtils.getRandomString((int)stringLength, (int)exchangeNumber);
        List exchangeIdSqlList = this.rearExchangeMapper.queryExchangeIdList();
        if (exchangeIdSqlList == null || exchangeIdSqlList.size() <= 0) {
            tableList = exchangeIdList;
            return tableList;
        }
        ArrayList exchangeIdExistList = new ArrayList();
        for (String str : exchangeIdList) {
            if (exchangeIdSqlList.contains(str)) continue;
            tableList.add(str);
        }
        return tableList;
    }

    public String exchangeRule(String exchangeId) {
        String defaultString = "btjb";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        Date newDate = new Date();
        String dateString = sdf.format(newDate);
        String montage = defaultString + dateString;
        String md5String = DigestUtils.md5DigestAsHex((byte[])montage.getBytes(StandardCharsets.UTF_8));
        String table = exchangeId + "&" + md5String;
        return table;
    }

    @Transactional(rollbackFor={Exception.class})
    public int updateRearExchange(ExchangeUpdatePO exchangeUpdatePO) {
        RearExchange rearExchange = new RearExchange();
        BeanUtils.copyProperties((Object)exchangeUpdatePO, (Object)rearExchange);
        rearExchange.setUpdateTime(DateUtils.getNowDate());
        rearExchange.setPropJson(JSON.toJSONString((Object)exchangeUpdatePO.getPropJsonList()));
        int updateState = this.rearExchangeMapper.updateRearExchange(rearExchange);
        this.rearExchangeMiddleServiceImpl.updateRearExchangeMiddle(exchangeUpdatePO);
        return updateState;
    }

    public int deleteRearExchangeByIds(Long[] Ids) {
        return this.rearExchangeMapper.deleteRearExchangeByIds(Ids);
    }

    public int deleteRearExchangeById(Long Id) {
        return this.rearExchangeMapper.deleteRearExchangeById(Id);
    }

    public List<ApplyConditionVO> applyConditionSelect() {
        ArrayList<ApplyConditionVO> applyConditionVOList = new ArrayList<ApplyConditionVO>();
        for (ExchangeApplyConditionEnums enumValue : EnumSet.allOf(ExchangeApplyConditionEnums.class)) {
            ApplyConditionVO applyConditionVO = new ApplyConditionVO();
            applyConditionVO.setCode(enumValue.getValue());
            applyConditionVO.setName(enumValue.getDesc());
            applyConditionVOList.add(applyConditionVO);
        }
        return applyConditionVOList;
    }

    public List<ExchangeListVO> queryServerList(ExchangeListPO exchangeListPO) {
        List<ExchangeListVO> exchangeListVOList = new ArrayList();
        exchangeListVOList = this.rearExchangeMapper.queryServerList(exchangeListPO);
        if (exchangeListVOList.size() <= 0) {
            return exchangeListVOList;
        }
        exchangeListVOList = this.valueHandle(exchangeListVOList);
        return exchangeListVOList;
    }

    public List<ExchangeListVO> valueHandle(List<ExchangeListVO> exchangeListVOList) {
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        List exchangeIdList = exchangeListVOList.stream().map(ExchangeListVO::getExchangeId).collect(Collectors.toList());
        List exchangeNumberOfUsesVOList = this.gameExchangeUseLogServiceImpl.selectNumberOfUses(exchangeIdList);
        for (ExchangeNumberOfUsesVO exchangeNumberOfUsesVO : exchangeNumberOfUsesVOList) {
            exchangeNumberOfUsesVO.setExchangeId(exchangeNumberOfUsesVO.getExchangeId().toUpperCase());
        }
        Map<String, Integer> numberOfUsesMap = exchangeNumberOfUsesVOList.stream().collect(Collectors.toMap(ExchangeNumberOfUsesVO::getExchangeId, ExchangeNumberOfUsesVO::getNumberOfUses));
        for (ExchangeListVO exchangeListVO : exchangeListVOList) {
            exchangeListVO.setExchangeStateName(ExchangeStateEnums.getDescByValue((Integer)exchangeListVO.getExchangeState()));
            exchangeListVO.setApplyConditionName(ExchangeApplyConditionEnums.getDescByValue((Integer)exchangeListVO.getApplyCondition()));
            if (exchangeListVO.getApplyFrequency() == 0) {
                exchangeListVO.setRemainingTimesName(ExchangeDescribeEnums.UNLIMITED.getDesc());
            } else {
                Integer number = numberOfUsesMap.get(exchangeListVO.getExchangeId());
                if (number != null && number > 0) {
                    exchangeListVO.setRemainingTimesName(String.valueOf(exchangeListVO.getApplyFrequency() - number));
                } else {
                    exchangeListVO.setRemainingTimesName(String.valueOf(exchangeListVO.getApplyFrequency()));
                }
            }
            if (exchangeListVO.getTakeEffectTime() == null) {
                exchangeListVO.setTakeEffectTimeName(ExchangeDescribeEnums.UNLIMITED.getDesc());
            } else {
                exchangeListVO.setTakeEffectTimeName(exchangeListVO.getTakeEffectTime().format(fmt));
            }
            if (exchangeListVO.getExpireTime() == null) {
                exchangeListVO.setExpireTimeName(ExchangeDescribeEnums.UNLIMITED.getDesc());
                continue;
            }
            exchangeListVO.setExpireTimeName(exchangeListVO.getExpireTime().format(fmt));
        }
        return exchangeListVOList;
    }
}

