/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.service.impl.game.exchange;

import com.ruoyi.common.core.utils.DateUtils;
import com.ruoyi.common.security.utils.SecurityUtils;
import com.ruoyi.rearend.domain.RearExchangeMiddle;
import com.ruoyi.rearend.domain.po.game.exchange.ExchangeMiddleInsertPO;
import com.ruoyi.rearend.domain.po.game.exchange.ExchangeUpdatePO;
import com.ruoyi.rearend.mapper.game.exchange.RearExchangeMiddleMapper;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RearExchangeMiddleServiceImpl {
    @Autowired
    private RearExchangeMiddleMapper rearExchangeMiddleMapper;

    public List<RearExchangeMiddle> selectRearExchangeMiddleList(RearExchangeMiddle rearExchangeMiddle) {
        return this.rearExchangeMiddleMapper.selectRearExchangeMiddleList(rearExchangeMiddle);
    }

    @Transactional(rollbackFor={Exception.class})
    public int updateRearExchangeMiddle(ExchangeUpdatePO exchangeUpdatePO) {
        int state = this.deleteBatchMiddle(exchangeUpdatePO.getExchangeId());
        if (exchangeUpdatePO.getServerIdList() != null && exchangeUpdatePO.getServerIdList().size() > 0) {
            ArrayList<ExchangeMiddleInsertPO> middleInsertPOList = new ArrayList<ExchangeMiddleInsertPO>();
            List serverIdList = exchangeUpdatePO.getServerIdList();
            for (int i = 0; i < serverIdList.size(); ++i) {
                ExchangeMiddleInsertPO exchangeMiddleInsertPO = new ExchangeMiddleInsertPO();
                exchangeMiddleInsertPO.setExchangeId(exchangeUpdatePO.getExchangeId());
                exchangeMiddleInsertPO.setRegionId((String)((List)serverIdList.get(i)).get(0));
                exchangeMiddleInsertPO.setServerId((String)((List)serverIdList.get(i)).get(1));
                exchangeMiddleInsertPO.setCreateBy(SecurityUtils.getUsername());
                exchangeMiddleInsertPO.setCreateTime(DateUtils.getNowDate());
                middleInsertPOList.add(exchangeMiddleInsertPO);
            }
            this.insertBatchMiddle(middleInsertPOList);
        }
        return state;
    }

    public void insertBatchMiddle(List<ExchangeMiddleInsertPO> middleInsertPOList) {
        this.rearExchangeMiddleMapper.insertBatchMiddle(middleInsertPOList);
    }

    public int deleteBatchMiddle(String exchangeId) {
        return this.rearExchangeMiddleMapper.deleteBatchMiddle(exchangeId);
    }
}

