/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.controller.statistics;

import com.ruoyi.common.core.web.controller.BaseController;
import com.ruoyi.common.core.web.domain.AjaxResult;
import com.ruoyi.common.core.web.page.TableDataInfo;
import com.ruoyi.common.security.annotation.RequiresPermissions;
import com.ruoyi.rearend.domain.po.statistics.DistributionDetailsPO;
import com.ruoyi.rearend.domain.po.statistics.DoubtfulDataPO;
import com.ruoyi.rearend.domain.po.statistics.FoundationOnAnalysisPO;
import com.ruoyi.rearend.domain.po.statistics.LogRetrievalPO;
import com.ruoyi.rearend.domain.po.statistics.RegisterRetainedUserPO;
import com.ruoyi.rearend.domain.po.statistics.UserDurationUpdatePO;
import com.ruoyi.rearend.domain.po.statistics.UserOnlineDurationPO;
import com.ruoyi.rearend.domain.po.statistics.UserRoleDurationPO;
import com.ruoyi.rearend.service.statistics.IAnalysisService;
import com.ruoyi.rearend.service.statistics.IUserRoleDurationService;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/analysis"})
public class AnalysisController
extends BaseController {
    @Autowired
    private IAnalysisService iAnalysisService;
    @Autowired
    private IUserRoleDurationService iUserRoleDurationService;

    @RequiresPermissions(value={"rearend:analysis:logRetrieval"})
    @PostMapping(value={"/logRetrieval"})
    public TableDataInfo logRetrieval(@Valid @RequestBody LogRetrievalPO logRetrievalPO) {
        return this.iAnalysisService.logRetrieval(logRetrievalPO);
    }

    @RequiresPermissions(value={"rearend:analysis:foundationOnAnalysis"})
    @PostMapping(value={"/foundationOnAnalysis"})
    public AjaxResult foundationOnAnalysis(@Valid @RequestBody FoundationOnAnalysisPO foundationOnAnalysisPO) {
        return this.success((Object)this.iAnalysisService.foundationOnAnalysis(foundationOnAnalysisPO));
    }

    @RequiresPermissions(value={"rearend:analysis:userOnlineDuration"})
    @PostMapping(value={"/userOnlineDuration"})
    public AjaxResult userOnlineDuration(@Valid @RequestBody UserOnlineDurationPO userOnlineDurationPO) {
        return this.success((Object)this.iAnalysisService.userOnlineDuration(userOnlineDurationPO));
    }

    @RequiresPermissions(value={"rearend:operateDailyAdd:userOnLineDetails"})
    @PostMapping(value={"/userOnLineDetails"})
    public TableDataInfo queryUserOnLineDetails(@RequestBody RegisterRetainedUserPO registerRetainedUserPO) {
        return this.iAnalysisService.queryUserOnLineDetails(registerRetainedUserPO);
    }

    @RequiresPermissions(value={"rearend:gameUserDuration:doubtfulDataList"})
    @PostMapping(value={"/doubtfulDataList"})
    public TableDataInfo doubtfulDataList(@RequestBody DoubtfulDataPO doubtfulDataPO) {
        return this.iAnalysisService.selectGameUserDurationList(doubtfulDataPO);
    }

    @RequiresPermissions(value={"rearend:gameUserDuration:userDurationUpdate"})
    @PostMapping(value={"/userDurationUpdate"})
    public AjaxResult userDurationUpdate(@RequestBody UserDurationUpdatePO userDurationUpdatePO) {
        return this.success((Object)this.iAnalysisService.userDurationUpdate(userDurationUpdatePO));
    }

    @RequiresPermissions(value={"rearend:gameUserDuration:userDurationDelete"})
    @GetMapping(value={"/userDurationDelete/{Id}"})
    public AjaxResult userDurationDelete(@PathVariable(value="Id") Long Id) {
        return this.success((Object)this.iAnalysisService.userDurationDelete(Id));
    }

    @RequiresPermissions(value={"rearend:analysis:distribution"})
    @PostMapping(value={"/distribution"})
    public AjaxResult distribution(@Valid @RequestBody UserRoleDurationPO userRoleDurationPO) {
        return this.success((Object)this.iUserRoleDurationService.distribution(userRoleDurationPO));
    }

    @RequiresPermissions(value={"rearend:analysis:distributionDetails"})
    @PostMapping(value={"/distributionDetails"})
    public TableDataInfo distributionDetails(@Valid @RequestBody DistributionDetailsPO distributionDetailsPO) {
        return this.iUserRoleDurationService.distributionDetails(distributionDetailsPO);
    }
}

