/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.controller.server;

import com.ruoyi.common.core.web.controller.BaseController;
import com.ruoyi.common.core.web.domain.AjaxResult;
import com.ruoyi.common.core.web.page.TableDataInfo;
import com.ruoyi.common.log.annotation.Log;
import com.ruoyi.common.log.enums.BusinessType;
import com.ruoyi.common.security.annotation.RequiresPermissions;
import com.ruoyi.rearend.domain.RearServerDispose;
import com.ruoyi.rearend.domain.po.server.ServerDisposeInsertPO;
import com.ruoyi.rearend.domain.po.server.ServerDisposeUpdatePO;
import com.ruoyi.rearend.service.server.IRearServerDisposeService;
import com.ruoyi.rearend.service.server.IRearServerService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rearServerDispose"})
public class RearServerDisposeController
extends BaseController {
    @Autowired
    private IRearServerDisposeService rearServerDisposeService;
    @Autowired
    private IRearServerService rearServerService;

    @RequiresPermissions(value={"rearend:rearServerDispose:list"})
    @GetMapping(value={"/list"})
    public TableDataInfo list(RearServerDispose rearServerDispose) {
        this.startPage();
        List list = this.rearServerDisposeService.selectRearServerDisposeList(rearServerDispose);
        return this.getDataTable(list);
    }

    @RequiresPermissions(value={"rearend:rearServerDispose:query"})
    @GetMapping(value={"/{Id}"})
    public AjaxResult getInfo(@PathVariable(value="Id") Long Id) {
        return this.success((Object)this.rearServerDisposeService.selectRearServerDisposeById(Id));
    }

    @RequiresPermissions(value={"rearend:rearServerDispose:add"})
    @Log(title="\u670d\u52a1\u5668\u914d\u7f6e", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ServerDisposeInsertPO serverDisposeInsertPO) {
        return this.toAjax(this.rearServerDisposeService.insertRearServerDispose(serverDisposeInsertPO));
    }

    @RequiresPermissions(value={"rearend:rearServerDispose:edit"})
    @Log(title="\u670d\u52a1\u5668\u914d\u7f6e", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ServerDisposeUpdatePO serverDisposeUpdatePO) {
        return this.toAjax(this.rearServerDisposeService.updateRearServerDispose(serverDisposeUpdatePO));
    }

    @RequiresPermissions(value={"rearend:rearServerDispose:remove"})
    @Log(title="\u670d\u52a1\u5668\u914d\u7f6e", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{Ids}"})
    public AjaxResult remove(@PathVariable Long[] Ids) {
        return this.toAjax(this.rearServerDisposeService.deleteRearServerDisposeByIds(Ids));
    }

    @GetMapping(value={"/middleDisposeTreeDetails/{serverId}"})
    public AjaxResult middleTreeDetails(@PathVariable(value="serverId") String serverId) {
        List middleTree = this.rearServerService.middleTree();
        List selectedTree = this.rearServerDisposeService.selectedTree(serverId);
        AjaxResult ajaxResult = AjaxResult.success();
        ajaxResult.put("checkedKeys", (Object)selectedTree);
        ajaxResult.put("menus", (Object)middleTree);
        return ajaxResult;
    }

    @GetMapping(value={"/serverIdSelect/{serverId}"})
    public AjaxResult serverIdSelect(@PathVariable(value="serverId") String serverId) {
        List disposeServerIdSelectVOList = this.rearServerDisposeService.serverIdSelect(serverId);
        return AjaxResult.success((Object)disposeServerIdSelectVOList);
    }
}

