/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.controller.server;

import com.ruoyi.common.core.web.controller.BaseController;
import com.ruoyi.common.core.web.domain.AjaxResult;
import com.ruoyi.common.core.web.page.TableDataInfo;
import com.ruoyi.common.log.annotation.Log;
import com.ruoyi.common.log.enums.BusinessType;
import com.ruoyi.common.security.annotation.RequiresPermissions;
import com.ruoyi.common.security.utils.SecurityUtils;
import com.ruoyi.rearend.domain.RearClientSwitch;
import com.ruoyi.rearend.domain.RearServerConfig;
import com.ruoyi.rearend.domain.po.server.RearServerListPO;
import com.ruoyi.rearend.domain.po.server.ServerInsertPO;
import com.ruoyi.rearend.domain.po.server.ServerUpdatePO;
import com.ruoyi.rearend.service.server.IRearServerService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/server"})
public class RearServerController
extends BaseController {
    @Autowired
    private IRearServerService rearServerService;

    @RequiresPermissions(value={"rearend:server:list"})
    @GetMapping(value={"/list"})
    public TableDataInfo list(RearServerListPO rearServerListPO) {
        List list = this.rearServerService.queryServerList(rearServerListPO);
        return this.getDataTable(list);
    }

    @RequiresPermissions(value={"rearend:server:query"})
    @GetMapping(value={"/{Id}"})
    public AjaxResult getInfo(@PathVariable(value="Id") Long Id) {
        return this.success((Object)this.rearServerService.selectRearServerById(Id));
    }

    @RequiresPermissions(value={"rearend:server:add"})
    @Log(title="\u670d\u52a1\u5668\u5217\u8868", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ServerInsertPO serverInsertPO) {
        String operName = SecurityUtils.getUsername();
        serverInsertPO.setCreateBy(operName);
        return this.toAjax(this.rearServerService.insertRearServer(serverInsertPO));
    }

    @RequiresPermissions(value={"rearend:server:edit"})
    @Log(title="\u670d\u52a1\u5668\u5217\u8868", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ServerUpdatePO serverUpdatePO) {
        return this.toAjax(this.rearServerService.updateRearServer(serverUpdatePO));
    }

    @RequiresPermissions(value={"rearend:server:remove"})
    @Log(title="\u670d\u52a1\u5668\u5217\u8868", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{Ids}"})
    public AjaxResult remove(@PathVariable Long[] Ids) {
        return this.toAjax(this.rearServerService.deleteRearServerByIds(Ids));
    }

    @GetMapping(value={"/select"})
    public AjaxResult stateSelect() {
        List serverStateSelectVOList = this.rearServerService.serverStateSelect();
        return AjaxResult.success((Object)serverStateSelectVOList);
    }

    @GetMapping(value={"/middleTree"})
    public AjaxResult middleTree() {
        List middleTree = this.rearServerService.middleTree();
        return this.success((Object)middleTree);
    }

    @GetMapping(value={"/middleTreeDetails/{serverId}"})
    public AjaxResult middleTreeDetails(@PathVariable(value="serverId") String serverId) {
        List middleTree = this.rearServerService.middleTree();
        List selectedTree = this.rearServerService.selectedTree(serverId);
        AjaxResult ajaxResult = AjaxResult.success();
        ajaxResult.put("checkedKeys", (Object)selectedTree);
        ajaxResult.put("menus", (Object)middleTree);
        return ajaxResult;
    }

    @GetMapping(value={"/clientSwitchQuery"})
    public AjaxResult clientSwitchQuery() {
        return this.success((Object)this.rearServerService.clientSwitchQuery());
    }

    @RequiresPermissions(value={"rearend:server:clientSwitch"})
    @PostMapping(value={"/clientSwitchUpdate"})
    public AjaxResult clientSwitchUpdate(@RequestBody RearClientSwitch rearClientSwitch) {
        return this.toAjax(this.rearServerService.clientSwitchUpdate(rearClientSwitch).booleanValue());
    }

    @RequiresPermissions(value={"rearend:server:queryServerConfig"})
    @GetMapping(value={"/queryServerConfig"})
    public RearServerConfig queryServerConfig(@PathVariable(value="serverId") String serverId) {
        RearServerConfig rearServerConfig = this.rearServerService.queryServerConfig(serverId);
        return rearServerConfig;
    }

    @RequiresPermissions(value={"rearend:server:serverSync"})
    @GetMapping(value={"/serverSync"})
    public AjaxResult serverSync() {
        return this.toAjax(this.rearServerService.serverSync().booleanValue());
    }

    @GetMapping(value={"/serverSyncQuery"})
    public AjaxResult serverSyncQuery() {
        return this.success((Object)this.rearServerService.serverSyncQuery());
    }

    @RequiresPermissions(value={"rearend:server:testServerUserClear"})
    @GetMapping(value={"/testServerUserClear/{serverId}"})
    public AjaxResult testServerUserClear(@PathVariable(value="serverId") String serverId) {
        return this.success((Object)this.rearServerService.testServerUserClear(serverId));
    }
}

