/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.controller.server;

import com.ruoyi.common.core.utils.poi.ExcelUtil;
import com.ruoyi.common.core.web.controller.BaseController;
import com.ruoyi.common.core.web.domain.AjaxResult;
import com.ruoyi.common.core.web.page.TableDataInfo;
import com.ruoyi.common.log.annotation.Log;
import com.ruoyi.common.log.enums.BusinessType;
import com.ruoyi.common.security.annotation.RequiresPermissions;
import com.ruoyi.rearend.domain.RearRegion;
import com.ruoyi.rearend.service.server.IRearRegionService;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/region"})
public class RearRegionController
extends BaseController {
    @Autowired
    private IRearRegionService rearRegionService;
    private static final Logger log = LoggerFactory.getLogger(RearRegionController.class);

    @GetMapping(value={"/testAndVerify"})
    public String testAndVerify() {
        log.info("\u670d\u52a1\u5668\u6a21\u5757\u670d\u52a1\u6b63\u5e38,date={}", (Object)new Date());
        return "\u670d\u52a1\u5668\u6a21\u5757\u6b63\u5e38";
    }

    @RequiresPermissions(value={"rearend:region:list"})
    @GetMapping(value={"/list"})
    public TableDataInfo list(RearRegion rearRegion) {
        this.startPage();
        List list = this.rearRegionService.selectRearRegionList(rearRegion);
        return this.getDataTable(list);
    }

    @RequiresPermissions(value={"rearend:region:export"})
    @Log(title="\u5927\u533a\u5217\u8868", businessType=BusinessType.EXPORT)
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, RearRegion rearRegion) {
        List list = this.rearRegionService.selectRearRegionList(rearRegion);
        ExcelUtil util = new ExcelUtil(RearRegion.class);
        util.exportExcel(response, list, "\u5927\u533a\u5217\u8868\u6570\u636e");
    }

    @RequiresPermissions(value={"rearend:region:query"})
    @GetMapping(value={"/{Id}"})
    public AjaxResult getInfo(@PathVariable(value="Id") Long Id) {
        return this.success((Object)this.rearRegionService.selectRearRegionById(Id));
    }

    @RequiresPermissions(value={"rearend:region:add"})
    @Log(title="\u5927\u533a\u5217\u8868", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody RearRegion rearRegion) {
        return this.toAjax(this.rearRegionService.insertRearRegion(rearRegion));
    }

    @RequiresPermissions(value={"rearend:region:edit"})
    @Log(title="\u5927\u533a\u5217\u8868", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody RearRegion rearRegion) {
        return this.toAjax(this.rearRegionService.updateRearRegion(rearRegion));
    }

    @RequiresPermissions(value={"rearend:region:remove"})
    @Log(title="\u5927\u533a\u5217\u8868", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{Ids}"})
    public AjaxResult remove(@PathVariable Long[] Ids) {
        return this.toAjax(this.rearRegionService.deleteRearRegionByIds(Ids));
    }

    @GetMapping(value={"/select"})
    public AjaxResult regionSelect() {
        List rearRegionSelectVOList = this.rearRegionService.regionSelect();
        return AjaxResult.success((Object)rearRegionSelectVOList);
    }
}

