/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.controller.server;

import com.ruoyi.common.core.utils.poi.ExcelUtil;
import com.ruoyi.common.core.web.controller.BaseController;
import com.ruoyi.common.core.web.domain.AjaxResult;
import com.ruoyi.common.core.web.page.TableDataInfo;
import com.ruoyi.common.log.annotation.Log;
import com.ruoyi.common.log.enums.BusinessType;
import com.ruoyi.common.security.annotation.RequiresPermissions;
import com.ruoyi.rearend.domain.RearGameWrap;
import com.ruoyi.rearend.service.server.IRearGameWrapService;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/gameWrap"})
public class RearGameWrapController
extends BaseController {
    @Autowired
    private IRearGameWrapService rearGameWrapService;

    @RequiresPermissions(value={"rearend:gameWrap:list"})
    @GetMapping(value={"/list"})
    public TableDataInfo list(RearGameWrap rearGameWrap) {
        this.startPage();
        List list = this.rearGameWrapService.gameWarpList(rearGameWrap);
        return this.getDataTable(list);
    }

    @RequiresPermissions(value={"rearend:gameWrap:export"})
    @Log(title="\u6e38\u620f\u5305\u7ec4", businessType=BusinessType.EXPORT)
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, RearGameWrap rearGameWrap) {
        List list = this.rearGameWrapService.selectRearGameWrapList(rearGameWrap);
        ExcelUtil util = new ExcelUtil(RearGameWrap.class);
        util.exportExcel(response, list, "\u6e38\u620f\u5305\u7ec4\u6570\u636e");
    }

    @RequiresPermissions(value={"rearend:gameWrap:query"})
    @GetMapping(value={"/{Id}"})
    public AjaxResult getInfo(@PathVariable(value="Id") Long Id) {
        return this.success((Object)this.rearGameWrapService.selectRearGameWrapById(Id));
    }

    @RequiresPermissions(value={"rearend:gameWrap:add"})
    @Log(title="\u6e38\u620f\u5305\u7ec4", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody RearGameWrap rearGameWrap) {
        return this.toAjax(this.rearGameWrapService.insertRearGameWrap(rearGameWrap));
    }

    @RequiresPermissions(value={"rearend:gameWrap:edit"})
    @Log(title="\u6e38\u620f\u5305\u7ec4", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody RearGameWrap rearGameWrap) {
        return this.toAjax(this.rearGameWrapService.updateRearGameWrap(rearGameWrap));
    }

    @RequiresPermissions(value={"rearend:gameWrap:remove"})
    @Log(title="\u6e38\u620f\u5305\u7ec4", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{Ids}"})
    public AjaxResult remove(@PathVariable Long[] Ids) {
        return this.toAjax(this.rearGameWrapService.deleteRearGameWrapByIds(Ids));
    }

    @GetMapping(value={"/select"})
    public AjaxResult stateSelect() {
        List gameWrapStateVOList = this.rearGameWrapService.gameWrapStateSelect();
        return AjaxResult.success((Object)gameWrapStateVOList);
    }
}

