/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.controller.server;

import com.ruoyi.common.core.utils.poi.ExcelUtil;
import com.ruoyi.common.core.web.controller.BaseController;
import com.ruoyi.common.core.web.domain.AjaxResult;
import com.ruoyi.common.core.web.page.TableDataInfo;
import com.ruoyi.common.log.annotation.Log;
import com.ruoyi.common.log.enums.BusinessType;
import com.ruoyi.common.security.annotation.RequiresPermissions;
import com.ruoyi.rearend.domain.RearChannel;
import com.ruoyi.rearend.service.server.IRearChannelService;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/channel"})
public class RearChannelController
extends BaseController {
    @Autowired
    private IRearChannelService rearChannelService;

    @RequiresPermissions(value={"rearend:channel:list"})
    @GetMapping(value={"/list"})
    public TableDataInfo list(RearChannel rearChannel) {
        this.startPage();
        List list = this.rearChannelService.selectRearChannelList(rearChannel);
        return this.getDataTable(list);
    }

    @RequiresPermissions(value={"rearend:channel:export"})
    @Log(title="\u6e20\u9053\u7ec4", businessType=BusinessType.EXPORT)
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, RearChannel rearChannel) {
        List list = this.rearChannelService.selectRearChannelList(rearChannel);
        ExcelUtil util = new ExcelUtil(RearChannel.class);
        util.exportExcel(response, list, "\u6e20\u9053\u7ec4\u6570\u636e");
    }

    @RequiresPermissions(value={"rearend:channel:query"})
    @GetMapping(value={"/{Id}"})
    public AjaxResult getInfo(@PathVariable(value="Id") Long Id) {
        return this.success((Object)this.rearChannelService.selectRearChannelById(Id));
    }

    @RequiresPermissions(value={"rearend:channel:add"})
    @Log(title="\u6e20\u9053\u7ec4", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody RearChannel rearChannel) {
        return this.toAjax(this.rearChannelService.insertRearChannel(rearChannel));
    }

    @RequiresPermissions(value={"rearend:channel:edit"})
    @Log(title="\u6e20\u9053\u7ec4", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody RearChannel rearChannel) {
        return this.toAjax(this.rearChannelService.updateRearChannel(rearChannel));
    }

    @RequiresPermissions(value={"rearend:channel:remove"})
    @Log(title="\u6e20\u9053\u7ec4", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{Ids}"})
    public AjaxResult remove(@PathVariable Long[] Ids) {
        return this.toAjax(this.rearChannelService.deleteRearChannelByIds(Ids));
    }

    @GetMapping(value={"/select"})
    public AjaxResult channelSelect() {
        List rearChannelSelectVOList = this.rearChannelService.channelSelect();
        return AjaxResult.success((Object)rearChannelSelectVOList);
    }
}

