/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.controller.palyer;

import com.ruoyi.common.core.web.controller.BaseController;
import com.ruoyi.common.core.web.domain.AjaxResult;
import com.ruoyi.common.log.annotation.Log;
import com.ruoyi.common.log.enums.BusinessType;
import com.ruoyi.common.security.annotation.RequiresPermissions;
import com.ruoyi.rearend.domain.po.player.BatchPlayerQueryPO;
import com.ruoyi.rearend.domain.po.player.MessageSwitchPO;
import com.ruoyi.rearend.domain.po.player.PlayerQueryPO;
import com.ruoyi.rearend.domain.po.player.PlayerRoleCheckPO;
import com.ruoyi.rearend.domain.po.player.ValidateLogonPO;
import com.ruoyi.rearend.domain.vo.player.PlayerQueryVO;
import com.ruoyi.rearend.service.player.IRearPlayerService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/player"})
public class RearPlayerController
extends BaseController {
    @Autowired
    private IRearPlayerService rearPlayerService;

    @RequiresPermissions(value={"rearend:player:list"})
    @GetMapping(value={"/list"})
    public AjaxResult list(PlayerQueryPO playerQueryPO) {
        PlayerQueryVO list = this.rearPlayerService.selectRearPlayerList(playerQueryPO);
        return AjaxResult.success((Object)list);
    }

    @GetMapping(value={"/regionSelect"})
    public AjaxResult regionSelectorSelect() {
        List regionSelectorVOList = this.rearPlayerService.regionSelectorSelect();
        return AjaxResult.success((Object)regionSelectorVOList);
    }

    @PostMapping(value={"/playerRoleCheck"})
    public AjaxResult playerRoleCheck(@RequestBody PlayerRoleCheckPO playerRoleCheckPO) {
        return AjaxResult.success((Object)this.rearPlayerService.playerRoleCheck(playerRoleCheckPO));
    }

    @PostMapping(value={"/batchPlayer"})
    public AjaxResult batchPlayerQuery(@RequestBody BatchPlayerQueryPO batchPlayerQueryPO) {
        return AjaxResult.success((Object)this.rearPlayerService.batchPlayerQuery(batchPlayerQueryPO));
    }

    @PostMapping(value={"/manyServerBatchPlayer"})
    public AjaxResult manyServerBatchPlayer(@RequestBody BatchPlayerQueryPO batchPlayerQueryPO) {
        return AjaxResult.success((Object)this.rearPlayerService.manyServerBatchPlayer(batchPlayerQueryPO));
    }

    @GetMapping(value={"/userLogOnServer"})
    public AjaxResult userLogOnServer(PlayerQueryPO playerQueryPO) {
        List list = this.rearPlayerService.userLogOnServer(playerQueryPO);
        return AjaxResult.success((Object)list);
    }

    @GetMapping(value={"/messageSwitch"})
    @RequiresPermissions(value={"rearend:player:debugSwitch"})
    @Log(title="\u73a9\u5bb6\u6d88\u606fdebug\u5f00\u5173", businessType=BusinessType.UPDATE)
    public AjaxResult messageSwitch(MessageSwitchPO messageSwitchPO) {
        boolean state = this.rearPlayerService.messageSwitch(messageSwitchPO);
        return AjaxResult.success((Object)state);
    }

    @GetMapping(value={"/validateLogon"})
    @RequiresPermissions(value={"rearend:player:validateLogon"})
    @Log(title="\u73a9\u5bb6\u767b\u5f55\u662f\u5426\u9a8c\u8bc1\u5f00\u5173", businessType=BusinessType.UPDATE)
    public AjaxResult validateLogon(ValidateLogonPO validateLogonPO) {
        boolean state = this.rearPlayerService.validateLogon(validateLogonPO);
        return AjaxResult.success((Object)state);
    }
}

