/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.controller.palyer;

import com.ruoyi.common.core.web.controller.BaseController;
import com.ruoyi.common.core.web.domain.AjaxResult;
import com.ruoyi.common.core.web.page.TableDataInfo;
import com.ruoyi.common.log.annotation.Log;
import com.ruoyi.common.log.enums.BusinessType;
import com.ruoyi.common.security.annotation.RequiresPermissions;
import com.ruoyi.rearend.domain.GameUserBan;
import com.ruoyi.rearend.domain.po.player.userban.GameUserBanAddPO;
import com.ruoyi.rearend.service.player.IGameUserBanService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/userBan"})
public class GameUserBanController
extends BaseController {
    @Autowired
    private IGameUserBanService gameUserBanService;

    @RequiresPermissions(value={"rearend:userBan:list"})
    @GetMapping(value={"/list"})
    public TableDataInfo list(GameUserBan gameUserBan) {
        List list = this.gameUserBanService.selectGameUserBanList(gameUserBan);
        return this.getDataTable(list);
    }

    @RequiresPermissions(value={"rearend:userBan:query"})
    @GetMapping(value={"/{Id}"})
    public AjaxResult getInfo(@PathVariable(value="Id") Long Id) {
        return this.success((Object)this.gameUserBanService.selectGameUserBanById(Id));
    }

    @RequiresPermissions(value={"rearend:userBan:add"})
    @Log(title="\u7528\u6237\u5c01\u7981", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody GameUserBanAddPO gameUserBanAddPO) {
        return this.toAjax(this.gameUserBanService.insertGameUserBan(gameUserBanAddPO));
    }

    @RequiresPermissions(value={"rearend:userBan:unseal"})
    @Log(title="\u7528\u6237\u89e3\u5c01", businessType=BusinessType.OTHER)
    @DeleteMapping(value={"/{Ids}"})
    public AjaxResult remove(@PathVariable Long[] Ids) {
        return this.toAjax(this.gameUserBanService.deleteGameUserBanByIds(Ids));
    }
}

