/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.controller.palyer;

import com.ruoyi.common.core.utils.poi.ExcelUtil;
import com.ruoyi.common.core.web.controller.BaseController;
import com.ruoyi.common.core.web.domain.AjaxResult;
import com.ruoyi.common.core.web.page.TableDataInfo;
import com.ruoyi.common.log.annotation.Log;
import com.ruoyi.common.log.enums.BusinessType;
import com.ruoyi.common.security.annotation.RequiresPermissions;
import com.ruoyi.rearend.domain.GameRoleKnapsack;
import com.ruoyi.rearend.domain.po.player.roleknapsack.RoleKnapsackOperatePO;
import com.ruoyi.rearend.domain.vo.player.RoleKnapsackExportVO;
import com.ruoyi.rearend.service.player.IGameRoleKnapsackService;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/gameRoleKnapsack"})
public class GameRoleKnapsackController
extends BaseController {
    @Autowired
    private IGameRoleKnapsackService gameRoleKnapsackService;

    @RequiresPermissions(value={"game:gameRoleKnapsack:list"})
    @GetMapping(value={"/list"})
    public TableDataInfo list(GameRoleKnapsack gameRoleKnapsack) {
        return this.gameRoleKnapsackService.selectGameRoleKnapsackList(gameRoleKnapsack);
    }

    @RequiresPermissions(value={"game:gameRoleKnapsack:export"})
    @Log(title="\u89d2\u8272\u80cc\u5305", businessType=BusinessType.EXPORT)
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, GameRoleKnapsack gameRoleKnapsack) {
        List list = this.gameRoleKnapsackService.exportGameRoleKnapsackList(gameRoleKnapsack);
        ExcelUtil util = new ExcelUtil(RoleKnapsackExportVO.class);
        util.exportExcel(response, list, "\u89d2\u8272\u80cc\u5305\u6570\u636e");
    }

    @RequiresPermissions(value={"game:gameRoleKnapsack:query"})
    @GetMapping(value={"/{Id}"})
    public AjaxResult getInfo(@PathVariable(value="Id") Long Id) {
        return this.success((Object)this.gameRoleKnapsackService.selectGameRoleKnapsackById(Id));
    }

    @RequiresPermissions(value={"game:gameRoleKnapsack:edit"})
    @Log(title="\u89d2\u8272\u80cc\u5305", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody List<RoleKnapsackOperatePO> roleKnapsackOperatePOList) {
        return this.toAjax(this.gameRoleKnapsackService.updateGameRoleKnapsack(roleKnapsackOperatePOList));
    }

    @RequiresPermissions(value={"game:gameRoleKnapsack:lock"})
    @Log(title="\u89d2\u8272\u80cc\u5305", businessType=BusinessType.OTHER)
    @PutMapping(value={"/lock"})
    public AjaxResult lock(@RequestBody List<RoleKnapsackOperatePO> roleKnapsackOperatePOList) {
        return this.toAjax(this.gameRoleKnapsackService.lockUnlockRoleKnapsack(roleKnapsackOperatePOList));
    }

    @RequiresPermissions(value={"game:gameRoleKnapsack:unlock"})
    @Log(title="\u89d2\u8272\u80cc\u5305", businessType=BusinessType.OTHER)
    @PutMapping(value={"/unlock"})
    public AjaxResult unlock(@RequestBody List<RoleKnapsackOperatePO> roleKnapsackOperatePOList) {
        return this.toAjax(this.gameRoleKnapsackService.lockUnlockRoleKnapsack(roleKnapsackOperatePOList));
    }

    @RequiresPermissions(value={"game:gameRoleKnapsack:delete"})
    @Log(title="\u89d2\u8272\u80cc\u5305", businessType=BusinessType.DELETE)
    @PutMapping(value={"/delete"})
    public AjaxResult delete(@RequestBody List<RoleKnapsackOperatePO> roleKnapsackOperatePOList) {
        return this.toAjax(this.gameRoleKnapsackService.deleteRoleKnapsack(roleKnapsackOperatePOList));
    }
}

