/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.controller.operate.trailer;

import com.ruoyi.common.core.utils.poi.ExcelUtil;
import com.ruoyi.common.core.web.controller.BaseController;
import com.ruoyi.common.core.web.domain.AjaxResult;
import com.ruoyi.common.core.web.page.TableDataInfo;
import com.ruoyi.common.log.annotation.Log;
import com.ruoyi.common.log.enums.BusinessType;
import com.ruoyi.common.security.annotation.RequiresPermissions;
import com.ruoyi.rearend.domain.GameVersionTrailer;
import com.ruoyi.rearend.domain.po.operate.trailer.TrailerGroundingPO;
import com.ruoyi.rearend.service.operate.trailer.IGameVersionTrailerService;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/gameVersionTrailer"})
public class GameVersionTrailerController
extends BaseController {
    @Autowired
    private IGameVersionTrailerService gameVersionTrailerService;

    @RequiresPermissions(value={"rearend:gameVersionTrailer:list"})
    @GetMapping(value={"/list"})
    public TableDataInfo list(GameVersionTrailer gameVersionTrailer) {
        this.startPage();
        List list = this.gameVersionTrailerService.selectGameVersionTrailerList(gameVersionTrailer);
        return this.getDataTable(list);
    }

    @RequiresPermissions(value={"rearend:gameVersionTrailer:export"})
    @Log(title="\u7248\u672c\u9884\u544a", businessType=BusinessType.EXPORT)
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, GameVersionTrailer gameVersionTrailer) {
        List list = this.gameVersionTrailerService.selectGameVersionTrailerList(gameVersionTrailer);
        ExcelUtil util = new ExcelUtil(GameVersionTrailer.class);
        util.exportExcel(response, list, "\u7248\u672c\u9884\u544a\u6570\u636e");
    }

    @RequiresPermissions(value={"rearend:gameVersionTrailer:query"})
    @GetMapping(value={"/{Id}"})
    public AjaxResult getInfo(@PathVariable(value="Id") Long Id) {
        return this.success((Object)this.gameVersionTrailerService.selectGameVersionTrailerById(Id));
    }

    @RequiresPermissions(value={"rearend:gameVersionTrailer:add"})
    @Log(title="\u7248\u672c\u9884\u544a", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TrailerGroundingPO trailerGroundingPO) {
        return this.toAjax(this.gameVersionTrailerService.insertGameVersionTrailer(trailerGroundingPO));
    }

    @RequiresPermissions(value={"rearend:gameVersionTrailer:edit"})
    @Log(title="\u7248\u672c\u9884\u544a", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody GameVersionTrailer gameVersionTrailer) {
        return this.toAjax(this.gameVersionTrailerService.updateGameVersionTrailer(gameVersionTrailer));
    }

    @RequiresPermissions(value={"rearend:gameVersionTrailer:remove"})
    @Log(title="\u7248\u672c\u9884\u544a", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{Ids}"})
    public AjaxResult offShelf(@PathVariable Long[] Ids) {
        return this.toAjax(this.gameVersionTrailerService.offShelf(Ids));
    }

    @GetMapping(value={"/queryGroundingNumber"})
    public AjaxResult queryGroundingNumber() {
        return this.success((Object)this.gameVersionTrailerService.queryGroundingNumber());
    }
}

