/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.controller.operate.questionnaire;

import com.ruoyi.common.core.utils.poi.ExcelUtil;
import com.ruoyi.common.core.web.controller.BaseController;
import com.ruoyi.common.core.web.domain.AjaxResult;
import com.ruoyi.common.core.web.page.TableDataInfo;
import com.ruoyi.common.log.annotation.Log;
import com.ruoyi.common.log.enums.BusinessType;
import com.ruoyi.common.security.annotation.RequiresPermissions;
import com.ruoyi.rearend.domain.RearQuestionnaire;
import com.ruoyi.rearend.domain.po.ServerCountPO;
import com.ruoyi.rearend.domain.po.operate.questionnaire.QuestionnaireAddPO;
import com.ruoyi.rearend.service.operate.questionnaire.IRearQuestionnaireService;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/questionnaire"})
public class RearQuestionnaireController
extends BaseController {
    @Autowired
    private IRearQuestionnaireService rearQuestionnaireService;

    @RequiresPermissions(value={"operate:questionnaire:list"})
    @GetMapping(value={"/list"})
    public TableDataInfo list(RearQuestionnaire rearQuestionnaire) {
        this.startPage();
        List list = this.rearQuestionnaireService.selectRearQuestionnaireList(rearQuestionnaire);
        return this.getDataTable(list);
    }

    @RequiresPermissions(value={"operate:questionnaire:export"})
    @Log(title="\u8c03\u67e5\u95ee\u5377", businessType=BusinessType.EXPORT)
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, RearQuestionnaire rearQuestionnaire) {
        List list = this.rearQuestionnaireService.selectRearQuestionnaireExport(rearQuestionnaire);
        ExcelUtil util = new ExcelUtil(RearQuestionnaire.class);
        util.exportExcel(response, list, "\u8c03\u67e5\u95ee\u5377\u6570\u636e");
    }

    @RequiresPermissions(value={"operate:questionnaire:query"})
    @GetMapping(value={"/{Id}"})
    public AjaxResult getInfo(@PathVariable(value="Id") Long Id) {
        return this.success((Object)this.rearQuestionnaireService.selectRearQuestionnaireById(Id));
    }

    @RequiresPermissions(value={"operate:questionnaire:add"})
    @Log(title="\u8c03\u67e5\u95ee\u5377", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody QuestionnaireAddPO questionnaireAddPO) {
        return this.success((Object)this.rearQuestionnaireService.insertRearQuestionnaire(questionnaireAddPO));
    }

    @RequiresPermissions(value={"operate:questionnaire:edit"})
    @Log(title="\u8c03\u67e5\u95ee\u5377", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody RearQuestionnaire rearQuestionnaire) {
        return this.toAjax(this.rearQuestionnaireService.updateRearQuestionnaire(rearQuestionnaire));
    }

    @RequiresPermissions(value={"operate:questionnaire:remove"})
    @Log(title="\u8c03\u67e5\u95ee\u5377", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{Ids}"})
    public AjaxResult remove(@PathVariable Long[] Ids) {
        return this.success((Object)this.rearQuestionnaireService.deleteRearQuestionnaireByIds(Ids));
    }

    @PostMapping(value={"/serverCount"})
    public AjaxResult serverCount(@RequestBody ServerCountPO serverCountPO) {
        return this.success((Object)this.rearQuestionnaireService.serverCount(serverCountPO));
    }

    @GetMapping(value={"/questionnaireKey"})
    public AjaxResult questionnaireKey() {
        return this.success(this.rearQuestionnaireService.questionnaireKey());
    }
}

