/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.controller.operate.officialgroup;

import com.ruoyi.common.core.utils.poi.ExcelUtil;
import com.ruoyi.common.core.web.controller.BaseController;
import com.ruoyi.common.core.web.domain.AjaxResult;
import com.ruoyi.common.core.web.page.TableDataInfo;
import com.ruoyi.common.log.annotation.Log;
import com.ruoyi.common.log.enums.BusinessType;
import com.ruoyi.common.security.annotation.RequiresPermissions;
import com.ruoyi.rearend.domain.RearOfficialGroup;
import com.ruoyi.rearend.service.operate.officialgroup.IRearOfficialGroupService;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rearOfficialGroup"})
public class RearOfficialGroupController
extends BaseController {
    @Autowired
    private IRearOfficialGroupService rearOfficialGroupService;

    @RequiresPermissions(value={"rearend:rearOfficialGroup:list"})
    @GetMapping(value={"/list"})
    public TableDataInfo list(RearOfficialGroup rearOfficialGroup) {
        this.startPage();
        List list = this.rearOfficialGroupService.selectRearOfficialGroupList(rearOfficialGroup);
        return this.getDataTable(list);
    }

    @RequiresPermissions(value={"rearend:rearOfficialGroup:export"})
    @Log(title="\u5b98\u65b9\u7fa4", businessType=BusinessType.EXPORT)
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, RearOfficialGroup rearOfficialGroup) {
        List list = this.rearOfficialGroupService.selectRearOfficialGroupList(rearOfficialGroup);
        ExcelUtil util = new ExcelUtil(RearOfficialGroup.class);
        util.exportExcel(response, list, "\u5b98\u65b9\u7fa4\u6570\u636e");
    }

    @RequiresPermissions(value={"rearend:rearOfficialGroup:query"})
    @GetMapping(value={"/{Id}"})
    public AjaxResult getInfo(@PathVariable(value="Id") Long Id) {
        return this.success((Object)this.rearOfficialGroupService.selectRearOfficialGroupById(Id));
    }

    @RequiresPermissions(value={"rearend:rearOfficialGroup:add"})
    @Log(title="\u5b98\u65b9\u7fa4", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody RearOfficialGroup rearOfficialGroup) {
        return this.toAjax(this.rearOfficialGroupService.insertRearOfficialGroup(rearOfficialGroup));
    }

    @RequiresPermissions(value={"rearend:rearOfficialGroup:edit"})
    @Log(title="\u5b98\u65b9\u7fa4", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody RearOfficialGroup rearOfficialGroup) {
        return this.toAjax(this.rearOfficialGroupService.updateRearOfficialGroup(rearOfficialGroup));
    }

    @RequiresPermissions(value={"rearend:rearOfficialGroup:remove"})
    @Log(title="\u5b98\u65b9\u7fa4", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{Ids}"})
    public AjaxResult remove(@PathVariable Long[] Ids) {
        return this.toAjax(this.rearOfficialGroupService.deleteRearOfficialGroupByIds(Ids));
    }
}

