/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.controller.operate.notice;

import com.ruoyi.common.core.web.controller.BaseController;
import com.ruoyi.common.core.web.domain.AjaxResult;
import com.ruoyi.common.core.web.page.TableDataInfo;
import com.ruoyi.common.log.annotation.Log;
import com.ruoyi.common.log.enums.BusinessType;
import com.ruoyi.common.security.annotation.RequiresPermissions;
import com.ruoyi.rearend.domain.GameNotice;
import com.ruoyi.rearend.domain.po.operate.notice.NoticeAddUpdatePO;
import com.ruoyi.rearend.domain.po.operate.notice.NoticeOperatePO;
import com.ruoyi.rearend.service.operate.notice.IGameNoticeService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/notice"})
public class GameNoticeController
extends BaseController {
    @Autowired
    private IGameNoticeService gameNoticeService;

    @RequiresPermissions(value={"rearend:notice:list"})
    @GetMapping(value={"/list"})
    public TableDataInfo list(GameNotice gameNotice) {
        this.startPage();
        List list = this.gameNoticeService.selectGameNoticeList(gameNotice);
        return this.getDataTable(list);
    }

    @RequiresPermissions(value={"rearend:notice:query"})
    @GetMapping(value={"/{Id}"})
    public AjaxResult getInfo(@PathVariable(value="Id") Long Id) {
        return this.success((Object)this.gameNoticeService.selectGameNoticeById(Id));
    }

    @RequiresPermissions(value={"rearend:notice:add"})
    @Log(title="\u6e38\u620f\u516c\u544a", businessType=BusinessType.INSERT)
    @PostMapping(value={"/add"})
    public AjaxResult add(@RequestBody NoticeAddUpdatePO noticeAddUpdatePO) {
        return this.toAjax(this.gameNoticeService.insertGameNotice(noticeAddUpdatePO));
    }

    @RequiresPermissions(value={"rearend:notice:edit"})
    @Log(title="\u6e38\u620f\u516c\u544a", businessType=BusinessType.UPDATE)
    @PutMapping(value={"/edit"})
    public AjaxResult edit(@RequestBody NoticeAddUpdatePO noticeAddUpdatePO) {
        return this.toAjax(this.gameNoticeService.updateGameNotice(noticeAddUpdatePO));
    }

    @RequiresPermissions(value={"rearend:notice:remove"})
    @Log(title="\u6e38\u620f\u516c\u544a", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{Ids}"})
    public AjaxResult remove(@PathVariable Long[] Ids) {
        return this.toAjax(this.gameNoticeService.deleteGameNoticeByIds(Ids));
    }

    @RequiresPermissions(value={"rearend:notice:upperBelowFrame"})
    @Log(title="\u6e38\u620f\u516c\u544a", businessType=BusinessType.OTHER)
    @PostMapping(value={"/upperBelowFrame"})
    public AjaxResult upperBelowFrame(@RequestBody NoticeOperatePO noticeOperatePO) {
        return this.toAjax(this.gameNoticeService.upperBelowFrame(noticeOperatePO));
    }

    @RequiresPermissions(value={"rearend:notice:upperBelowMove"})
    @Log(title="\u6e38\u620f\u516c\u544a", businessType=BusinessType.OTHER)
    @PostMapping(value={"/upperBelowMove"})
    public AjaxResult upperBelowMove(@RequestBody NoticeOperatePO noticeOperatePO) {
        return this.toAjax(this.gameNoticeService.upperBelowMove(noticeOperatePO));
    }

    @RequiresPermissions(value={"rearend:notice:toppingMove"})
    @Log(title="\u6e38\u620f\u516c\u544a", businessType=BusinessType.OTHER)
    @PostMapping(value={"/toppingMove"})
    public AjaxResult toppingMove(@RequestBody NoticeOperatePO noticeOperatePO) {
        return this.toAjax(this.gameNoticeService.toppingMove(noticeOperatePO));
    }
}

