/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.controller.operate.message;

import com.ruoyi.common.core.web.controller.BaseController;
import com.ruoyi.common.core.web.domain.AjaxResult;
import com.ruoyi.common.core.web.page.TableDataInfo;
import com.ruoyi.common.log.annotation.Log;
import com.ruoyi.common.log.enums.BusinessType;
import com.ruoyi.common.security.annotation.RequiresPermissions;
import com.ruoyi.rearend.domain.GameMessage;
import com.ruoyi.rearend.domain.po.operate.message.GameMessageListPO;
import com.ruoyi.rearend.service.operate.message.IGameMessageService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/gameMessage"})
public class GameMessageController
extends BaseController {
    @Autowired
    private IGameMessageService gameMessageService;

    @RequiresPermissions(value={"game:gameMessage:list"})
    @GetMapping(value={"/list"})
    public TableDataInfo list(GameMessageListPO gameMessageListPO) {
        this.startPage();
        List list = this.gameMessageService.selectGameMessageList(gameMessageListPO);
        return this.getDataTable(list);
    }

    @RequiresPermissions(value={"game:gameMessage:query"})
    @GetMapping(value={"/{Id}"})
    public AjaxResult getInfo(@PathVariable(value="Id") Long Id) {
        return this.success((Object)this.gameMessageService.selectGameMessageById(Id));
    }

    @RequiresPermissions(value={"game:gameMessage:add"})
    @Log(title="\u6e38\u620f\u6d88\u606f", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody GameMessage gameMessage) {
        return this.success((Object)this.gameMessageService.insertGameMessage(gameMessage));
    }

    @RequiresPermissions(value={"game:gameMessage:remove"})
    @Log(title="\u6e38\u620f\u6d88\u606f", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{Ids}"})
    public AjaxResult remove(@PathVariable Long[] Ids) {
        return this.success((Object)this.gameMessageService.deleteGameMessageByIds(Ids));
    }
}

