/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.controller.operate.mail;

import com.ruoyi.common.core.web.controller.BaseController;
import com.ruoyi.common.core.web.domain.AjaxResult;
import com.ruoyi.common.core.web.page.TableDataInfo;
import com.ruoyi.common.log.annotation.Log;
import com.ruoyi.common.log.enums.BusinessType;
import com.ruoyi.common.security.annotation.RequiresPermissions;
import com.ruoyi.rearend.domain.GameMail;
import com.ruoyi.rearend.domain.po.operate.mail.GameMailAddPO;
import com.ruoyi.rearend.domain.po.operate.mail.GameMailUpdatePO;
import com.ruoyi.rearend.enums.operate.MailInternalMarkEnums;
import com.ruoyi.rearend.service.operate.mail.IGameMailService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/userInternalMail"})
public class GameMailInternalController
extends BaseController {
    @Autowired
    private IGameMailService gameMailService;

    @RequiresPermissions(value={"rearend:userInternalMail:list"})
    @GetMapping(value={"/list"})
    public TableDataInfo list(GameMail gameMail) {
        this.startPage();
        gameMail.setMailInternalMark(MailInternalMarkEnums.INTERNAL_MAIL.getValue());
        List list = this.gameMailService.selectGameMailList(gameMail);
        return this.getDataTable(list);
    }

    @RequiresPermissions(value={"rearend:userInternalMail:query"})
    @GetMapping(value={"/{Id}"})
    public AjaxResult getInfo(@PathVariable(value="Id") Long Id) {
        return this.success((Object)this.gameMailService.selectGameMailById(Id));
    }

    @RequiresPermissions(value={"rearend:userInternalMail:add"})
    @Log(title="\u5185\u90e8\u90ae\u4ef6", businessType=BusinessType.INSERT)
    @PostMapping(value={"/add"})
    public AjaxResult add(@RequestBody GameMailAddPO gameMailAddPO) {
        gameMailAddPO.setMailInternalMark(MailInternalMarkEnums.INTERNAL_MAIL.getValue());
        return this.toAjax(this.gameMailService.insertGameMail(gameMailAddPO));
    }

    @RequiresPermissions(value={"rearend:userInternalMail:edit"})
    @Log(title="\u5185\u90e8\u90ae\u4ef6", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/update"})
    public AjaxResult update(@RequestBody GameMailUpdatePO gameMailUpdatePO) {
        return this.toAjax(this.gameMailService.updateGameMail(gameMailUpdatePO));
    }

    @GetMapping(value={"/timeDevelop/{days}"})
    public AjaxResult timeDevelop(@PathVariable(value="days") Integer days) {
        return this.success(this.gameMailService.timeDevelop(days));
    }
}

