/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.controller.operate.mail;

import com.ruoyi.common.core.utils.poi.ExcelUtil;
import com.ruoyi.common.core.web.controller.BaseController;
import com.ruoyi.common.core.web.domain.AjaxResult;
import com.ruoyi.common.core.web.page.TableDataInfo;
import com.ruoyi.common.log.annotation.Log;
import com.ruoyi.common.log.enums.BusinessType;
import com.ruoyi.common.security.annotation.RequiresPermissions;
import com.ruoyi.rearend.domain.GameMailExamine;
import com.ruoyi.rearend.domain.po.operate.mail.MailExaminePO;
import com.ruoyi.rearend.service.operate.mail.IGameMailExamineService;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mailExamine"})
public class GameMailExamineController
extends BaseController {
    @Autowired
    private IGameMailExamineService gameMailExamineService;

    @RequiresPermissions(value={"rearend:mailExamine:list"})
    @GetMapping(value={"/list"})
    public TableDataInfo list(GameMailExamine gameMailExamine) {
        this.startPage();
        List list = this.gameMailExamineService.selectGameMailExamineList(gameMailExamine);
        return this.getDataTable(list);
    }

    @RequiresPermissions(value={"rearend:mailExamine:export"})
    @Log(title="\u6e38\u620f\u90ae\u4ef6\u5ba1\u6838", businessType=BusinessType.EXPORT)
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, GameMailExamine gameMailExamine) {
        List list = this.gameMailExamineService.selectGameMailExamineList(gameMailExamine);
        ExcelUtil util = new ExcelUtil(GameMailExamine.class);
        util.exportExcel(response, list, "\u6e38\u620f\u90ae\u4ef6\u5ba1\u6838\u6570\u636e");
    }

    @RequiresPermissions(value={"rearend:mailExamine:query"})
    @GetMapping(value={"/{Id}"})
    public AjaxResult getInfo(@PathVariable(value="Id") Long Id) {
        return this.success((Object)this.gameMailExamineService.selectGameMailExamineById(Id));
    }

    @RequiresPermissions(value={"rearend:mailExamine:add"})
    @Log(title="\u6e38\u620f\u90ae\u4ef6\u5ba1\u6838", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody GameMailExamine gameMailExamine) {
        return this.toAjax(this.gameMailExamineService.insertGameMailExamine(gameMailExamine));
    }

    @RequiresPermissions(value={"rearend:mailExamine:edit"})
    @Log(title="\u6e38\u620f\u90ae\u4ef6\u5ba1\u6838", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody GameMailExamine gameMailExamine) {
        return this.toAjax(this.gameMailExamineService.updateGameMailExamine(gameMailExamine));
    }

    @RequiresPermissions(value={"rearend:mailExamine:remove"})
    @Log(title="\u6e38\u620f\u90ae\u4ef6\u5ba1\u6838", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{Ids}"})
    public AjaxResult remove(@PathVariable Long[] Ids) {
        return this.toAjax(this.gameMailExamineService.deleteGameMailExamineByIds(Ids));
    }

    @RequiresPermissions(value={"rearend:mailExamine:examine"})
    @Log(title="\u6e38\u620f\u90ae\u4ef6\u5ba1\u6838", businessType=BusinessType.OTHER)
    @PostMapping(value={"/mailExamine"})
    public AjaxResult mailExamine(@RequestBody MailExaminePO mailExaminePO) {
        return this.toAjax(this.gameMailExamineService.mailExamine(mailExaminePO));
    }
}

