/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.controller.operate.giftpack;

import com.ruoyi.common.core.utils.poi.ExcelUtil;
import com.ruoyi.common.core.web.controller.BaseController;
import com.ruoyi.common.core.web.domain.AjaxResult;
import com.ruoyi.common.core.web.page.TableDataInfo;
import com.ruoyi.common.log.annotation.Log;
import com.ruoyi.common.log.enums.BusinessType;
import com.ruoyi.common.security.annotation.RequiresPermissions;
import com.ruoyi.rearend.domain.RearGiftPack;
import com.ruoyi.rearend.domain.po.game.giftpack.GiftPackBatchAddPO;
import com.ruoyi.rearend.service.operate.giftpack.IRearGiftPackService;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rearGiftPack"})
public class RearGiftPackController
extends BaseController {
    @Autowired
    private IRearGiftPackService rearGiftPackService;

    @RequiresPermissions(value={"rearend:rearGiftPack:list"})
    @GetMapping(value={"/list"})
    public TableDataInfo list(RearGiftPack rearGiftPack) {
        this.startPage();
        List list = this.rearGiftPackService.selectRearGiftPackList(rearGiftPack);
        return this.getDataTable(list);
    }

    @RequiresPermissions(value={"rearend:rearGiftPack:export"})
    @Log(title="\u6e38\u620f\u793c\u5305", businessType=BusinessType.EXPORT)
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, RearGiftPack rearGiftPack) {
        List list = this.rearGiftPackService.selectRearGiftPackList(rearGiftPack);
        ExcelUtil util = new ExcelUtil(RearGiftPack.class);
        util.exportExcel(response, list, "\u6e38\u620f\u793c\u5305\u6570\u636e");
    }

    @RequiresPermissions(value={"rearend:rearGiftPack:query"})
    @GetMapping(value={"/{Id}"})
    public AjaxResult getInfo(@PathVariable(value="Id") Long Id) {
        return this.success((Object)this.rearGiftPackService.selectRearGiftPackById(Id));
    }

    @RequiresPermissions(value={"rearend:rearGiftPack:add"})
    @Log(title="\u6e38\u620f\u793c\u5305", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody RearGiftPack rearGiftPack) {
        return this.toAjax(this.rearGiftPackService.insertRearGiftPack(rearGiftPack));
    }

    @RequiresPermissions(value={"rearend:rearGiftPack:edit"})
    @Log(title="\u6e38\u620f\u793c\u5305", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody RearGiftPack rearGiftPack) {
        return this.toAjax(this.rearGiftPackService.updateRearGiftPack(rearGiftPack));
    }

    @RequiresPermissions(value={"rearend:rearGiftPack:remove"})
    @Log(title="\u6e38\u620f\u793c\u5305", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{Ids}"})
    public AjaxResult remove(@PathVariable Long[] Ids) {
        return this.toAjax(this.rearGiftPackService.deleteRearGiftPackByIds(Ids));
    }

    @RequiresPermissions(value={"rearend:rearGiftPack:batchAdd"})
    @Log(title="\u6279\u91cf\u65b0\u589e\u6e38\u620f\u793c\u5305", businessType=BusinessType.INSERT)
    @PostMapping(value={"/batchAdd"})
    public AjaxResult giftPackBatch(@RequestBody GiftPackBatchAddPO giftPackBatchAddPO) {
        return this.success((Object)this.rearGiftPackService.giftPackBatch(giftPackBatchAddPO));
    }
}

