/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.controller.operate.event;

import com.ruoyi.common.core.utils.poi.ExcelUtil;
import com.ruoyi.common.core.web.controller.BaseController;
import com.ruoyi.common.core.web.domain.AjaxResult;
import com.ruoyi.common.core.web.page.TableDataInfo;
import com.ruoyi.common.log.annotation.Log;
import com.ruoyi.common.log.enums.BusinessType;
import com.ruoyi.common.security.annotation.RequiresPermissions;
import com.ruoyi.rearend.domain.RearVersionNotice;
import com.ruoyi.rearend.service.operate.event.IRearVersionNoticeService;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/versionNotice"})
public class RearVersionNoticeController
extends BaseController {
    @Autowired
    private IRearVersionNoticeService rearVersionNoticeService;

    @RequiresPermissions(value={"rearend:versionNotice:list"})
    @GetMapping(value={"/list"})
    public TableDataInfo list(RearVersionNotice rearVersionNotice) {
        this.startPage();
        List list = this.rearVersionNoticeService.selectRearVersionNoticeList(rearVersionNotice);
        return this.getDataTable(list);
    }

    @RequiresPermissions(value={"rearend:versionNotice:export"})
    @Log(title="\u7248\u672c\u516c\u544a", businessType=BusinessType.EXPORT)
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, RearVersionNotice rearVersionNotice) {
        List list = this.rearVersionNoticeService.selectRearVersionNoticeList(rearVersionNotice);
        ExcelUtil util = new ExcelUtil(RearVersionNotice.class);
        util.exportExcel(response, list, "\u7248\u672c\u516c\u544a\u6570\u636e");
    }

    @RequiresPermissions(value={"rearend:versionNotice:query"})
    @GetMapping(value={"/{Id}"})
    public AjaxResult getInfo(@PathVariable(value="Id") Long Id) {
        return this.success((Object)this.rearVersionNoticeService.selectRearVersionNoticeById(Id));
    }

    @RequiresPermissions(value={"rearend:versionNotice:add"})
    @Log(title="\u7248\u672c\u516c\u544a", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody RearVersionNotice rearVersionNotice) {
        return this.toAjax(this.rearVersionNoticeService.insertRearVersionNotice(rearVersionNotice));
    }

    @RequiresPermissions(value={"rearend:versionNotice:edit"})
    @Log(title="\u7248\u672c\u516c\u544a", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody RearVersionNotice rearVersionNotice) {
        return this.toAjax(this.rearVersionNoticeService.updateRearVersionNotice(rearVersionNotice));
    }

    @RequiresPermissions(value={"rearend:versionNotice:remove"})
    @Log(title="\u7248\u672c\u516c\u544a", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{Ids}"})
    public AjaxResult remove(@PathVariable Long[] Ids) {
        return this.toAjax(this.rearVersionNoticeService.deleteRearVersionNoticeByIds(Ids));
    }
}

