/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.controller.operate.event;

import com.ruoyi.common.core.web.controller.BaseController;
import com.ruoyi.common.core.web.domain.AjaxResult;
import com.ruoyi.common.core.web.page.TableDataInfo;
import com.ruoyi.common.log.annotation.Log;
import com.ruoyi.common.log.enums.BusinessType;
import com.ruoyi.common.security.annotation.RequiresPermissions;
import com.ruoyi.rearend.domain.RearExcitingEvents;
import com.ruoyi.rearend.domain.po.operate.event.RearExcitingEventsAddPO;
import com.ruoyi.rearend.domain.po.operate.event.RearExcitingEventsListPO;
import com.ruoyi.rearend.enums.operate.EventsStateEnums;
import com.ruoyi.rearend.service.operate.event.IRearExcitingEventsService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/excitingEvents"})
public class RearExcitingEventsController
extends BaseController {
    @Autowired
    private IRearExcitingEventsService rearExcitingEventsService;

    @RequiresPermissions(value={"rearend:excitingEvents:list"})
    @GetMapping(value={"/list"})
    public TableDataInfo list(RearExcitingEventsListPO rearExcitingEventsListPO) {
        this.startPage();
        List list = this.rearExcitingEventsService.selectRearExcitingEventsList(rearExcitingEventsListPO);
        return this.getDataTable(list);
    }

    @RequiresPermissions(value={"rearend:excitingEvents:query"})
    @GetMapping(value={"/{Id}"})
    public AjaxResult getInfo(@PathVariable(value="Id") Long Id) {
        return this.success((Object)this.rearExcitingEventsService.selectRearExcitingEventsById(Id));
    }

    @RequiresPermissions(value={"rearend:excitingEvents:add"})
    @Log(title="\u7cbe\u5f69\u4e8b\u4ef6", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody RearExcitingEventsAddPO rearExcitingEventsAddPO) {
        return this.success((Object)this.rearExcitingEventsService.insertRearExcitingEvents(rearExcitingEventsAddPO));
    }

    @RequiresPermissions(value={"rearend:excitingEvents:edit"})
    @Log(title="\u7cbe\u5f69\u4e8b\u4ef6", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody RearExcitingEvents rearExcitingEvents) {
        return this.toAjax(this.rearExcitingEventsService.updateRearExcitingEvents(rearExcitingEvents));
    }

    @RequiresPermissions(value={"rearend:excitingEvents:remove"})
    @Log(title="\u7cbe\u5f69\u4e8b\u4ef6", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{Ids}"})
    public AjaxResult remove(@PathVariable Long[] Ids) {
        return this.toAjax(this.rearExcitingEventsService.deleteRearExcitingEventsByIds(Ids));
    }

    @RequiresPermissions(value={"rearend:excitingEvents:grounding"})
    @Log(title="\u7cbe\u5f69\u4e8b\u4ef6", businessType=BusinessType.OTHER)
    @DeleteMapping(value={"/grounding/{id}"})
    public AjaxResult remove(@PathVariable Long id) {
        return this.success((Object)this.rearExcitingEventsService.upDownShelves(id, EventsStateEnums.PLACED.getValue()));
    }

    @RequiresPermissions(value={"rearend:excitingEvents:offShelf"})
    @Log(title="\u7cbe\u5f69\u4e8b\u4ef6", businessType=BusinessType.OTHER)
    @DeleteMapping(value={"/offShelf/{id}"})
    public AjaxResult offShelf(@PathVariable Long id) {
        return this.success((Object)this.rearExcitingEventsService.upDownShelves(id, EventsStateEnums.OFF_SHELF.getValue()));
    }
}

