/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.controller.game.internalplayer;

import com.ruoyi.common.core.utils.poi.ExcelUtil;
import com.ruoyi.common.core.web.controller.BaseController;
import com.ruoyi.common.core.web.domain.AjaxResult;
import com.ruoyi.common.core.web.page.TableDataInfo;
import com.ruoyi.common.log.annotation.Log;
import com.ruoyi.common.log.enums.BusinessType;
import com.ruoyi.common.security.annotation.RequiresPermissions;
import com.ruoyi.rearend.domain.InternalPlayer;
import com.ruoyi.rearend.domain.po.game.internalplayer.InternalPlayerAddPO;
import com.ruoyi.rearend.service.game.internalplayer.IInternalPlayerService;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/internalPlayer"})
public class InternalPlayerController
extends BaseController {
    @Autowired
    private IInternalPlayerService internalPlayerService;

    @RequiresPermissions(value={"rearend:internalPlayer:list"})
    @GetMapping(value={"/list"})
    public TableDataInfo list(InternalPlayer internalPlayer) {
        this.startPage();
        List list = this.internalPlayerService.selectInternalPlayerList(internalPlayer);
        return this.getDataTable(list);
    }

    @RequiresPermissions(value={"rearend:internalPlayer:export"})
    @Log(title="\u5185\u90e8\u73a9\u5bb6", businessType=BusinessType.EXPORT)
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, InternalPlayer internalPlayer) {
        List list = this.internalPlayerService.selectInternalPlayerList(internalPlayer);
        ExcelUtil util = new ExcelUtil(InternalPlayer.class);
        util.exportExcel(response, list, "\u5185\u90e8\u73a9\u5bb6\u6570\u636e");
    }

    @RequiresPermissions(value={"rearend:internalPlayer:query"})
    @GetMapping(value={"/{Id}"})
    public AjaxResult getInfo(@PathVariable(value="Id") Long Id) {
        return this.success((Object)this.internalPlayerService.selectInternalPlayerById(Id));
    }

    @RequiresPermissions(value={"rearend:internalPlayer:add"})
    @Log(title="\u5185\u90e8\u73a9\u5bb6", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody InternalPlayerAddPO internalPlayerAddPO) {
        return this.success(this.internalPlayerService.insertInternalPlayer(internalPlayerAddPO));
    }

    @PostMapping(value={"/batchAddDetection"})
    public AjaxResult batchAddDetection(@RequestBody InternalPlayerAddPO internalPlayerAddPO) {
        return this.success((Object)this.internalPlayerService.batchAddDetection(internalPlayerAddPO));
    }

    @RequiresPermissions(value={"rearend:internalPlayer:edit"})
    @Log(title="\u5185\u90e8\u73a9\u5bb6", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody InternalPlayer internalPlayer) {
        return this.success(this.internalPlayerService.updateInternalPlayer(internalPlayer));
    }
}

