/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.controller.game.exchange;

import com.ruoyi.common.core.web.controller.BaseController;
import com.ruoyi.common.core.web.domain.AjaxResult;
import com.ruoyi.common.core.web.page.TableDataInfo;
import com.ruoyi.common.log.annotation.Log;
import com.ruoyi.common.log.enums.BusinessType;
import com.ruoyi.common.security.annotation.RequiresPermissions;
import com.ruoyi.rearend.domain.po.game.exchange.ExchangeBatchPO;
import com.ruoyi.rearend.domain.po.game.exchange.ExchangeInsertPO;
import com.ruoyi.rearend.domain.po.game.exchange.ExchangeListPO;
import com.ruoyi.rearend.domain.po.game.exchange.ExchangeUpdatePO;
import com.ruoyi.rearend.service.game.exchange.IRearExchangeService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/exchange"})
public class RearExchangeController
extends BaseController {
    @Autowired
    private IRearExchangeService rearExchangeService;

    @RequiresPermissions(value={"rearend:exchange:list"})
    @GetMapping(value={"/list"})
    public TableDataInfo list(ExchangeListPO exchangeListPO) {
        this.startPage();
        List list = this.rearExchangeService.queryServerList(exchangeListPO);
        return this.getDataTable(list);
    }

    @RequiresPermissions(value={"rearend:exchange:query"})
    @GetMapping(value={"/{Id}"})
    public AjaxResult getInfo(@PathVariable(value="Id") Long Id) {
        return this.success((Object)this.rearExchangeService.selectRearExchangeById(Id));
    }

    @RequiresPermissions(value={"rearend:exchange:add"})
    @Log(title="\u5151\u6362\u7801", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ExchangeInsertPO exchangeInsertPO) {
        return this.toAjax(this.rearExchangeService.insertRearExchange(exchangeInsertPO));
    }

    @RequiresPermissions(value={"rearend:exchange:batchAdd"})
    @Log(title="\u6279\u91cf\u65b0\u589e\u5151\u6362\u7801", businessType=BusinessType.INSERT)
    @PostMapping(value={"/batchAdd"})
    public AjaxResult batchAdd(@RequestBody ExchangeBatchPO exchangeBatchPO) {
        return this.success((Object)this.rearExchangeService.exchangeBatch(exchangeBatchPO));
    }

    @RequiresPermissions(value={"rearend:exchange:edit"})
    @Log(title="\u5151\u6362\u7801", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ExchangeUpdatePO exchangeUpdatePO) {
        return this.toAjax(this.rearExchangeService.updateRearExchange(exchangeUpdatePO));
    }

    @RequiresPermissions(value={"rearend:exchange:remove"})
    @Log(title="\u5151\u6362\u7801", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{Ids}"})
    public AjaxResult remove(@PathVariable Long[] Ids) {
        return this.toAjax(this.rearExchangeService.deleteRearExchangeByIds(Ids));
    }

    @GetMapping(value={"/select"})
    public AjaxResult stateSelect() {
        List serverStateSelectVOList = this.rearExchangeService.applyConditionSelect();
        return AjaxResult.success((Object)serverStateSelectVOList);
    }
}

