/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.auth.service;

import com.ruoyi.auth.enums.LoginAccount37Enums;
import com.ruoyi.auth.service.SysPasswordService;
import com.ruoyi.auth.service.SysRecordLogService;
import com.ruoyi.common.core.domain.R;
import com.ruoyi.common.core.enums.UserStatus;
import com.ruoyi.common.core.exception.ServiceException;
import com.ruoyi.common.core.text.Convert;
import com.ruoyi.common.core.utils.StringUtils;
import com.ruoyi.common.core.utils.ip.IpUtils;
import com.ruoyi.common.redis.service.RedisService;
import com.ruoyi.common.security.utils.SecurityUtils;
import com.ruoyi.system.api.RemoteUserService;
import com.ruoyi.system.api.domain.SysUser;
import com.ruoyi.system.api.model.LoginUser;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.DigestUtils;

@Component
public class SysLoginService {
    @Autowired
    private RemoteUserService remoteUserService;
    @Autowired
    private SysPasswordService passwordService;
    @Autowired
    private SysRecordLogService recordLogService;
    @Autowired
    private RedisService redisService;
    private static String logOn37PstKey = "nwQxrR@*wJ9N3b&uJ";
    private static final long expireTime = 1440L;

    public LoginUser login(String username, String password) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{username, password})) {
            this.recordLogService.recordLogininfor(username, "Error", "\u7528\u6237/\u5bc6\u7801\u5fc5\u987b\u586b\u5199");
            throw new ServiceException("\u7528\u6237/\u5bc6\u7801\u5fc5\u987b\u586b\u5199");
        }
        if (password.length() < 5 || password.length() > 20) {
            this.recordLogService.recordLogininfor(username, "Error", "\u7528\u6237\u5bc6\u7801\u4e0d\u5728\u6307\u5b9a\u8303\u56f4");
            throw new ServiceException("\u7528\u6237\u5bc6\u7801\u4e0d\u5728\u6307\u5b9a\u8303\u56f4");
        }
        if (username.length() < 2 || username.length() > 20) {
            this.recordLogService.recordLogininfor(username, "Error", "\u7528\u6237\u540d\u4e0d\u5728\u6307\u5b9a\u8303\u56f4");
            throw new ServiceException("\u7528\u6237\u540d\u4e0d\u5728\u6307\u5b9a\u8303\u56f4");
        }
        String blackStr = Convert.toStr((Object)this.redisService.getCacheObject("sys_config:sys.login.blackIPList"));
        if (IpUtils.isMatchedIp((String)blackStr, (String)IpUtils.getIpAddr())) {
            this.recordLogService.recordLogininfor(username, "Error", "\u5f88\u9057\u61be\uff0c\u8bbf\u95eeIP\u5df2\u88ab\u5217\u5165\u7cfb\u7edf\u9ed1\u540d\u5355");
            throw new ServiceException("\u5f88\u9057\u61be\uff0c\u8bbf\u95eeIP\u5df2\u88ab\u5217\u5165\u7cfb\u7edf\u9ed1\u540d\u5355");
        }
        R userResult = this.remoteUserService.getUserInfo(username, "inner");
        if (StringUtils.isNull((Object)userResult) || StringUtils.isNull((Object)userResult.getData())) {
            this.recordLogService.recordLogininfor(username, "Error", "\u767b\u5f55\u7528\u6237\u4e0d\u5b58\u5728");
            throw new ServiceException("\u767b\u5f55\u7528\u6237\uff1a" + username + " \u4e0d\u5b58\u5728");
        }
        if (R.FAIL == userResult.getCode()) {
            throw new ServiceException(userResult.getMsg());
        }
        LoginUser userInfo = (LoginUser)userResult.getData();
        SysUser user = ((LoginUser)userResult.getData()).getSysUser();
        if (UserStatus.DELETED.getCode().equals(user.getDelFlag())) {
            this.recordLogService.recordLogininfor(username, "Error", "\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u8d26\u53f7\u5df2\u88ab\u5220\u9664");
            throw new ServiceException("\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u8d26\u53f7\uff1a" + username + " \u5df2\u88ab\u5220\u9664");
        }
        if (UserStatus.DISABLE.getCode().equals(user.getStatus())) {
            this.recordLogService.recordLogininfor(username, "Error", "\u7528\u6237\u5df2\u505c\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            throw new ServiceException("\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u8d26\u53f7\uff1a" + username + " \u5df2\u505c\u7528");
        }
        this.passwordService.validate(user, password);
        this.recordLogService.recordLogininfor(username, "Success", "\u767b\u5f55\u6210\u529f");
        this.redisService.setCacheObject(username, (Object)password, Long.valueOf(1440L), TimeUnit.MINUTES);
        return userInfo;
    }

    public LoginUser login37Overseas(String usernamePast) {
        String username = this.overseas37SignCheck(usernamePast);
        if (StringUtils.isEmpty((String)LoginAccount37Enums.getDescByValue((String)username))) {
            this.recordLogService.recordLogininfor(username, "Error", "\u975e37\u8d26\u53f7\u4f7f\u7528\u6d77\u5916\u767b\u5f55");
            throw new ServiceException("\u975e\u6d77\u5916\u8d26\u53f7,\u7981\u6b62\u4f7f\u7528\u6d77\u5916\u767b\u5f55");
        }
        if (username.length() < 2 || username.length() > 20) {
            this.recordLogService.recordLogininfor(username, "Error", "\u7528\u6237\u540d\u4e0d\u5728\u6307\u5b9a\u8303\u56f4");
            throw new ServiceException("\u7528\u6237\u540d\u4e0d\u5728\u6307\u5b9a\u8303\u56f4");
        }
        String blackStr = Convert.toStr((Object)this.redisService.getCacheObject("sys_config:sys.login.blackIPList"));
        if (IpUtils.isMatchedIp((String)blackStr, (String)IpUtils.getIpAddr())) {
            this.recordLogService.recordLogininfor(username, "Error", "\u5f88\u9057\u61be\uff0c\u8bbf\u95eeIP\u5df2\u88ab\u5217\u5165\u7cfb\u7edf\u9ed1\u540d\u5355");
            throw new ServiceException("\u5f88\u9057\u61be\uff0c\u8bbf\u95eeIP\u5df2\u88ab\u5217\u5165\u7cfb\u7edf\u9ed1\u540d\u5355");
        }
        R userResult = this.remoteUserService.getUserInfo(username, "inner");
        if (StringUtils.isNull((Object)userResult) || StringUtils.isNull((Object)userResult.getData())) {
            this.recordLogService.recordLogininfor(username, "Error", "\u767b\u5f55\u7528\u6237\u4e0d\u5b58\u5728");
            throw new ServiceException("\u767b\u5f55\u7528\u6237\uff1a" + username + " \u4e0d\u5b58\u5728");
        }
        if (R.FAIL == userResult.getCode()) {
            throw new ServiceException(userResult.getMsg());
        }
        LoginUser userInfo = (LoginUser)userResult.getData();
        SysUser user = ((LoginUser)userResult.getData()).getSysUser();
        if (UserStatus.DELETED.getCode().equals(user.getDelFlag())) {
            this.recordLogService.recordLogininfor(username, "Error", "\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u8d26\u53f7\u5df2\u88ab\u5220\u9664");
            throw new ServiceException("\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u8d26\u53f7\uff1a" + username + " \u5df2\u88ab\u5220\u9664");
        }
        if (UserStatus.DISABLE.getCode().equals(user.getStatus())) {
            this.recordLogService.recordLogininfor(username, "Error", "\u7528\u6237\u5df2\u505c\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            throw new ServiceException("\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u8d26\u53f7\uff1a" + username + " \u5df2\u505c\u7528");
        }
        this.recordLogService.recordLogininfor(username, "Success", "\u767b\u5f55\u6210\u529f");
        this.redisService.setCacheObject(username, null, Long.valueOf(1440L), TimeUnit.MINUTES);
        return userInfo;
    }

    public String overseas37SignCheck(String username) {
        String deleteString = username.replace("?", "");
        List<String> serverList = Arrays.asList(deleteString.split("&"));
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < serverList.size(); ++i) {
            String[] keyValue = serverList.get(i).split("=");
            map.put(keyValue[0], keyValue[1]);
        }
        if (StringUtils.isEmpty((String)((String)map.get("uname"))) || StringUtils.isEmpty((String)((String)map.get("time"))) || StringUtils.isEmpty((String)((String)map.get("sign")))) {
            this.recordLogService.recordLogininfor(username, "Error", "37\u6d77\u5916\u8d26\u53f7\u767b\u5f55,\u53c2\u6570\u7f3a\u5931");
            throw new ServiceException("\u6d77\u5916\u8d26\u53f7,\u53c2\u6570\u7f3a\u5931");
        }
        Long pastTime = Long.valueOf((String)map.get("time")) * 1000L;
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(pastTime);
        calendar.add(11, 1);
        long newTimeStamp = calendar.getTimeInMillis();
        Long timestamp = System.currentTimeMillis();
        if (timestamp > newTimeStamp) {
            this.recordLogService.recordLogininfor(username, "Error", "37\u6d77\u5916\u8d26\u53f7\u767b\u5f55,time\u8d85\u8fc71\u5c0f\u65f6");
            throw new ServiceException("\u6d77\u5916\u8d26\u53f7,time\u65f6\u95f4\u8fc7\u671f");
        }
        String encryption = (String)map.get("uname") + (String)map.get("time") + logOn37PstKey;
        String sign = DigestUtils.md5DigestAsHex((byte[])encryption.getBytes(StandardCharsets.UTF_8));
        if (!((String)map.get("sign")).equals(sign)) {
            this.recordLogService.recordLogininfor(username, "Error", "37\u6d77\u5916\u8d26\u53f7\u767b\u5f55,sign\u4e0d\u901a\u8fc7");
            throw new ServiceException("\u6d77\u5916\u8d26\u53f7,sign\u4e0d\u901a\u8fc7");
        }
        return (String)map.get("uname");
    }

    public void logout(String loginName) {
        this.recordLogService.recordLogininfor(loginName, "Logout", "\u9000\u51fa\u6210\u529f");
    }

    public void register(String username, String password) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{username, password})) {
            throw new ServiceException("\u7528\u6237/\u5bc6\u7801\u5fc5\u987b\u586b\u5199");
        }
        if (username.length() < 2 || username.length() > 20) {
            throw new ServiceException("\u8d26\u6237\u957f\u5ea6\u5fc5\u987b\u57282\u523020\u4e2a\u5b57\u7b26\u4e4b\u95f4");
        }
        if (password.length() < 5 || password.length() > 20) {
            throw new ServiceException("\u5bc6\u7801\u957f\u5ea6\u5fc5\u987b\u57285\u523020\u4e2a\u5b57\u7b26\u4e4b\u95f4");
        }
        SysUser sysUser = new SysUser();
        sysUser.setUserName(username);
        sysUser.setNickName(username);
        sysUser.setPassword(SecurityUtils.encryptPassword((String)password));
        R registerResult = this.remoteUserService.registerUserInfo(sysUser, "inner");
        if (R.FAIL == registerResult.getCode()) {
            throw new ServiceException(registerResult.getMsg());
        }
        this.recordLogService.recordLogininfor(username, "Register", "\u6ce8\u518c\u6210\u529f");
    }
}

