/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.analysis.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.ruoyi.analysis.domain.AnalysisLinuxFileLog;
import com.ruoyi.analysis.domain.po.LogRetrievalPO;
import com.ruoyi.analysis.domain.po.LogRetrievalQueryPO;
import com.ruoyi.analysis.service.IAnalysisLinuxFileLogService;
import com.ruoyi.analysis.service.IJournalRetrievalService;
import com.ruoyi.common.core.exception.ServiceException;
import com.ruoyi.common.core.utils.StringUtils;
import com.ruoyi.common.core.web.page.TableDataInfo;
import com.ruoyi.common.redis.service.RedisService;
import com.ruoyi.common.security.utils.SecurityUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class JournalRetrievalServiceImpl
implements IJournalRetrievalService {
    @Value(value="${meta.data.linuxAccount}")
    private String linuxAccount;
    @Value(value="${meta.data.linuxPassword}")
    private String linuxPassword;
    @Autowired
    private IAnalysisLinuxFileLogService iAnalysisLinuxFileLogService;
    private static final String projectName = "lucky";
    private static final String settingType = "test";
    private static final String localFilePath = "/btjb/lucky/log";
    private static final String LOG_KEY = "log_key";
    @Autowired
    private RedisService redisService;
    private static final Logger log = LoggerFactory.getLogger(JournalRetrievalServiceImpl.class);
    private static ThreadPoolExecutor executorService = new ThreadPoolExecutor(10, 12, 1000L, TimeUnit.MILLISECONDS, new LinkedBlockingDeque<Runnable>(1000), Executors.defaultThreadFactory(), new ThreadPoolExecutor.AbortPolicy());

    public TableDataInfo logRetrieval(LogRetrievalPO logRetrievalPO) {
        ArrayList<String> dataList = new ArrayList<String>();
        log.info("\u7528\u6237={},\u8fdb\u884c\u65e5\u5fd7\u68c0\u7d22", (Object)SecurityUtils.getUsername());
        LogRetrievalQueryPO logRetrievalQueryPO = this.logRetrievalHandle(logRetrievalPO);
        if (this.redisService.hasKey(LOG_KEY).booleanValue()) {
            throw new ServiceException("\u5f53\u524d\u6709\u8fdb\u7a0b\u6b63\u5728\u67e5\u8be2\u4e2d,\u8bf7\u7a0d\u540e\u518d\u8bd5...");
        }
        this.redisService.setCacheObject(LOG_KEY, (Object)true);
        this.redisService.expire(LOG_KEY, 15L);
        TableDataInfo tableDataInfo = new TableDataInfo();
        List fileDataFutureList = this.fileDataHandle(logRetrievalPO, logRetrievalQueryPO);
        int number = 0;
        while (number <= 20) {
            ++number;
            if (((Future)fileDataFutureList.get(0)).isDone()) break;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        ArrayList fileDataALLList = new ArrayList();
        for (Future future : fileDataFutureList) {
            try {
                List fileDataList = (List)future.get();
                fileDataALLList.addAll(fileDataList);
            }
            catch (Exception e) {
                log.info("\u6587\u4ef6\u53d6\u51fa\u7ed3\u679c\u65f6,\u5b58\u5728\u5931\u8d25");
            }
        }
        Date startTime = (Date)logRetrievalPO.getLogTime().get(0);
        Date endTime = (Date)logRetrievalPO.getLogTime().get(1);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (int i = 0; i < fileDataALLList.size(); ++i) {
            if (fileDataALLList.get(i) == null) continue;
            JSONObject dataMap = JSON.parseObject((String)((String)fileDataALLList.get(i)));
            Date fileTime = null;
            try {
                fileTime = sdf.parse(dataMap.get("#time").toString());
            }
            catch (Exception e) {
                throw new ServiceException("\u6587\u4ef6\u5b58\u5728\u5f02\u5e38\u65f6\u95f4,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!" + (String)fileDataALLList.get(i));
            }
            if (fileTime.getTime() < startTime.getTime() && fileTime.getTime() > endTime.getTime()) continue;
            if (logRetrievalQueryPO.getConditionList() == null || logRetrievalQueryPO.getConditionList().size() < 0) {
                dataList.add(((String)fileDataALLList.get(i)).toString());
                continue;
            }
            String forData = ((String)fileDataALLList.get(i)).toString();
            boolean allContained = logRetrievalQueryPO.getConditionList().stream().allMatch(subString -> forData.contains((CharSequence)subString));
            if (!allContained) continue;
            dataList.add(((String)fileDataALLList.get(i)).toString());
        }
        int startIndex = (logRetrievalPO.getPageNum() - 1) * logRetrievalPO.getPageSize();
        int endIndex = Math.min(startIndex + logRetrievalPO.getPageSize(), dataList.size());
        List currentPageList = dataList.subList(startIndex, endIndex);
        tableDataInfo.setTotal((long)dataList.size());
        tableDataInfo.setCode(200);
        tableDataInfo.setRows(currentPageList);
        this.redisService.deleteObject(LOG_KEY);
        log.info("\u7528\u6237:{},\u65e5\u5fd7\u68c0\u7d22\u5b8c\u6bd5" + SecurityUtils.getUsername());
        return tableDataInfo;
    }

    public LogRetrievalQueryPO logRetrievalHandle(LogRetrievalPO logRetrievalPO) {
        LogRetrievalQueryPO logRetrievalQueryPO = new LogRetrievalQueryPO();
        logRetrievalQueryPO.setServerId(logRetrievalPO.getServerId());
        long millisecondPerDay = 86400000L;
        long daysBetween = (((Date)logRetrievalPO.getLogTime().get(1)).getTime() - ((Date)logRetrievalPO.getLogTime().get(0)).getTime()) / millisecondPerDay;
        if (daysBetween > 7L) {
            throw new ServiceException("\u6682\u53ea\u652f\u6301\u95f4\u9694\u65f6\u95f4\u4e3a7\u5929\u7684\u65f6\u95f4!");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        logRetrievalQueryPO.setStartTime(sdf.format((Date)logRetrievalPO.getLogTime().get(0)));
        logRetrievalQueryPO.setEndTime(sdf.format((Date)logRetrievalPO.getLogTime().get(1)));
        if (logRetrievalPO.getSearchList() == null || logRetrievalPO.getSearchList().size() == 0) {
            return logRetrievalQueryPO;
        }
        String symbol = "\"";
        ArrayList<String> conditionList = new ArrayList<String>();
        for (int i = 0; i < logRetrievalPO.getSearchList().size(); ++i) {
            String condition = null;
            Map map = (Map)logRetrievalPO.getSearchList().get(i);
            condition = symbol + (String)map.get("joinIn") + symbol;
            if (!StringUtils.isEmpty((String)((String)map.get("value")))) {
                condition = condition + ":" + symbol + (String)map.get("value") + symbol;
            }
            conditionList.add(condition);
        }
        logRetrievalQueryPO.setConditionList(conditionList);
        return logRetrievalQueryPO;
    }

    public List<Future<List<String>>> fileDataHandle(LogRetrievalPO logRetrievalPO, LogRetrievalQueryPO logRetrievalQueryPO) {
        ArrayList<Future<List<String>>> fileDataList = new ArrayList<Future<List<String>>>();
        DateTimeFormatter formatterSpecific = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDate startDate = LocalDate.parse(logRetrievalQueryPO.getStartTime(), formatter);
        LocalDate endDate = LocalDate.parse(logRetrievalQueryPO.getEndTime(), formatter);
        ArrayList<String> timeSlotList = new ArrayList<String>();
        while (startDate.isBefore(endDate) || startDate.isEqual(endDate)) {
            String add = startDate.format(formatterSpecific);
            timeSlotList.add(add);
            startDate = startDate.plusDays(1L);
        }
        ArrayList<String> timeAllList = new ArrayList<String>();
        for (int i = 0; i < timeSlotList.size(); ++i) {
            for (int z = 0; z < 24; ++z) {
                String hourTime;
                if (z <= 9) {
                    hourTime = (String)timeSlotList.get(i) + "-0" + z;
                    timeAllList.add(hourTime);
                    continue;
                }
                hourTime = (String)timeSlotList.get(i) + "-" + z;
                timeAllList.add(hourTime);
            }
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        HashMap fileMap = new HashMap();
        for (int i = 0; i < timeSlotList.size(); ++i) {
            AnalysisLinuxFileLog analysisLinuxFileLog = this.iAnalysisLinuxFileLogService.queryServerUpToDateLog(logRetrievalPO.getServerId(), (String)timeSlotList.get(i));
            if (analysisLinuxFileLog == null || StringUtils.isEmpty((String)analysisLinuxFileLog.getFileTime())) {
                fileMap.put(timeSlotList.get(i), true);
                continue;
            }
            String createTime = sdf.format(analysisLinuxFileLog.getCreateTime());
            if (createTime.equals(analysisLinuxFileLog.getFileTime())) {
                fileMap.put(timeSlotList.get(i), true);
                continue;
            }
            String fileName = "log." + (String)timeSlotList.get(i) + "-00_0";
            File file = new File("/btjb/lucky/log/" + fileName);
            boolean exists = file.exists();
            fileMap.put(timeSlotList.get(i), !exists);
        }
        String recordTime = "";
        for (int i = 0; i < timeAllList.size(); ++i) {
            String specificDateFor = ((String)timeAllList.get(i)).substring(0, 10);
            Boolean linuxObtain = (Boolean)fileMap.get(specificDateFor);
            String fileName = "log." + (String)timeAllList.get(i) + "_0";
            String remoteFilePath = "/btjb/lucky/serverlog/test/gameserver/test_game_" + logRetrievalPO.getServerId() + "/logs/userlog/" + fileName;
            String fileAddress = "/btjb/lucky/log/" + fileName;
            Future futureList = this.timeFileExport(remoteFilePath, fileAddress, linuxObtain, logRetrievalPO.getServerIp());
            fileDataList.add(futureList);
            if (specificDateFor.equals(recordTime)) continue;
            recordTime = specificDateFor;
            AnalysisLinuxFileLog analysisLinuxFileLog = new AnalysisLinuxFileLog();
            analysisLinuxFileLog.setServerId(logRetrievalPO.getServerId());
            analysisLinuxFileLog.setFileTime(specificDateFor);
            this.iAnalysisLinuxFileLogService.insertAnalysisLinuxFileLog(analysisLinuxFileLog);
        }
        return fileDataList;
    }

    public Future<List<String>> timeFileExport(String remoteFilePath, String fileAddress, Boolean linuxObtain, String serverIp) {
        return executorService.submit(() -> {
            ArrayList<String> mapList = new ArrayList<String>();
            try {
                if (linuxObtain.booleanValue()) {
                    Session session = null;
                    String linuxIp = serverIp;
                    try {
                        JSch jsch = new JSch();
                        session = jsch.getSession(this.linuxAccount, linuxIp, 22);
                        session.setPassword(this.linuxPassword);
                        session.setConfig("StrictHostKeyChecking", "no");
                        session.connect();
                    }
                    catch (Exception e) {
                        log.info("\u8fde\u63a5linux\u83b7\u53d6\u6587\u4ef6\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                    }
                    ChannelSftp channel = (ChannelSftp)session.openChannel("sftp");
                    channel.connect();
                    channel.get(remoteFilePath, localFilePath);
                    channel.disconnect();
                    session.disconnect();
                }
                try (FileInputStream inputStream = new FileInputStream(fileAddress);
                     Scanner scanner = new Scanner(inputStream);){
                    while (scanner.hasNextLine()) {
                        mapList.add(scanner.nextLine());
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                log.info("\u5f02\u5e38\u7ebf\u7a0b\u6c60: \u83b7\u53d6\u6587\u4ef6\u89e3\u6790\u5f02\u5e38,\u5730\u5740={},\u5f02\u5e38={}", (Object)remoteFilePath, (Object)e.getMessage());
            }
            return mapList;
        });
    }
}

